
#include <avr/io.h>
#include "wiring.h"
#include "pins_arduino.h"

#define PA 1
#define PB 2
#define PC 3
#define PD 4
#define PE 5
#define PF 6
#define PG 7

const uint8_t PROGMEM digital_pin_to_port_PGM[] =
{
    /* 0 */		PE,
    /* 1 */		PE,
    /* 2 */		PE,
    /* 3 */		PE,
    /* 4 */		PE,
    /* 5 */		PE,
    /* 6 */		PE,
    /* 7 */		PE,

    /* 8 */		PD,
    /* 9 */		PD,
    /* 10 */	PD,
    /* 11 */	PD,
    /* 12 */	PD,

    /* 13 */	PG,

    /* 14 */	PB,
    /* 15 */	PB,
    /* 16 */	PB,
    /* 17 */	PB,

    /* 18 */	PG,
    /* 19 */	PG,

    /* 20 */	PD,
    /* 21 */	PD,

    /* 22 */	PG,

    /* 23 */	PC,
    /* 24 */	PC,
    /* 25 */	PC,
    /* 26 */	PC,
    /* 27 */	PC,
    /* 28 */	PC,
    /* 29 */	PC,
    /* 30 */	PA,
    /* 31 */	PA,
    /* 32 */	PA,
    /* 33 */	PA,
    /* 34 */	PG,
    /* 35 */	PC,

    /* 36 */	PF,
    /* 37 */	PF,
    /* 38 */	PF,
    /* 39 */	PF,
    /* 40 */	PF,
    /* 41 */	PF,

    /* 42 */	PB

};

const uint8_t PROGMEM digital_pin_to_bit_mask_PGM[] =
{
    /* 0 */		_BV(0),
    /* 1 */		_BV(1),
    /* 2 */		_BV(2),
    /* 3 */		_BV(3),
    /* 4 */		_BV(4),
    /* 5 */		_BV(5),
    /* 6 */		_BV(6),
    /* 7 */		_BV(7),

    /* 8 */		_BV(2),
    /* 9 */		_BV(3),
    /* 10 */	_BV(4),
    /* 11 */	_BV(6),
    /* 12 */	_BV(7),

    /* 13 */	_BV(0),

    /* 14 */	_BV(0),
    /* 15 */	_BV(4),
    /* 16 */	_BV(5),
    /* 17 */	_BV(6),

    /* 18 */	_BV(3),
    /* 19 */	_BV(4),

    /* 20 */	_BV(0),
    /* 21 */	_BV(1),

    /* 22 */	_BV(1),

    /* 23 */	_BV(0),
    /* 24 */	_BV(1),
    /* 25 */	_BV(2),
    /* 26 */	_BV(3),
    /* 27 */	_BV(4),
    /* 28 */	_BV(5),
    /* 29 */	_BV(6),
    /* 30 */	_BV(4),
    /* 31 */	_BV(5),
    /* 32 */	_BV(6),
    /* 33 */	_BV(7),
    /* 34 */	_BV(2),
    /* 35 */	_BV(7),

    /* 36 */	_BV(0),
    /* 37 */	_BV(1),
    /* 38 */	_BV(2),
    /* 39 */	_BV(3),
    /* 40 */	_BV(4),
    /* 41 */	_BV(5),

    /* 42 */	_BV(7),

};

const uint8_t PROGMEM digital_pin_to_timer_PGM[] = {

    /* 0 */  NOT_ON_TIMER,
    /* 1 */  NOT_ON_TIMER,
    /* 2 */  NOT_ON_TIMER,
    /* 3 */  SOFT_PWM,
    /* 4 */  NOT_ON_TIMER,
    /* 5 */  SOFT_PWM,
    /* 6 */  SOFT_PWM,
    /* 7 */  NOT_ON_TIMER,

    /* 8 */  NOT_ON_TIMER,
    /* 9 */  SOFT_PWM,
    /* 10 */ SOFT_PWM,
    /* 11 */ SOFT_PWM,
    /* 12 */ SOFT_PWM,

    /* 13 */ NOT_ON_TIMER,

    /* 14 */ NOT_ON_TIMER,
    /* 15 */ TIMER0A,
    /* 16 */ TIMER1A,
    /* 17 */ TIMER1B,

    /* 18 */ NOT_ON_TIMER,
    /* 19 */ NOT_ON_TIMER,

    /* 20 */ NOT_ON_TIMER,
    /* 21 */ NOT_ON_TIMER,

    /* 22 */ NOT_ON_TIMER,
    /* 23 */ NOT_ON_TIMER,
    /* 24 */ NOT_ON_TIMER,
    /* 25 */ NOT_ON_TIMER,
    /* 26 */ NOT_ON_TIMER,
    /* 27 */ NOT_ON_TIMER,
    /* 28 */ NOT_ON_TIMER,
    /* 29 */ NOT_ON_TIMER,
    /* 30 */ NOT_ON_TIMER,
    /* 31 */ NOT_ON_TIMER,
    /* 32 */ NOT_ON_TIMER,
    /* 33 */ NOT_ON_TIMER,
    /* 34 */ NOT_ON_TIMER,
    /* 35 */ NOT_ON_TIMER,

    /* 36 */ NOT_ON_TIMER,
    /* 37 */ NOT_ON_TIMER,
    /* 38 */ NOT_ON_TIMER,
    /* 39 */ NOT_ON_TIMER,
    /* 40 */ NOT_ON_TIMER,
    /* 41 */ NOT_ON_TIMER,

    /* 42 */ TIMER2A,
};

const uint8_t PROGMEM digital_pin_to_pwm_channel_PGM[] = {

    /* 0 */  NO_SOFTPWM,
    /* 1  */  NO_SOFTPWM,
    /* 2 */  NO_SOFTPWM,
    /* 3 */  SOFTPWM_CHANNEL0,
    /* 4 */  NO_SOFTPWM,
    /* 5 */  SOFTPWM_CHANNEL1,
    /* 6 */  SOFTPWM_CHANNEL2,
    /* 7 */  NO_SOFTPWM,

    /* 8 */  NO_SOFTPWM,
    /* 9 */  SOFTPWM_CHANNEL3,
    /* 10 */ SOFTPWM_CHANNEL4,
    /* 11  */ SOFTPWM_CHANNEL5,
    /* 12 */ SOFTPWM_CHANNEL6,

    /* 13 */ NO_SOFTPWM,

    /* 14 */ NO_SOFTPWM,
    /* 15 */ NO_SOFTPWM,
    /* 16 */ NO_SOFTPWM,
    /* 17 */ NO_SOFTPWM,

    /* 18 */ NO_SOFTPWM,
    /* 19 */ NO_SOFTPWM,

    /* 20 */ NO_SOFTPWM,
    /* 21 */ NO_SOFTPWM,

    /* 22 */ NO_SOFTPWM,
    /* 23 */ NO_SOFTPWM,
    /* 24 */ NO_SOFTPWM,
    /* 25 */ NO_SOFTPWM,
    /* 26 */ NO_SOFTPWM,
    /* 27 */ NO_SOFTPWM,
    /* 28 */ NO_SOFTPWM,
    /* 29 */ NO_SOFTPWM,
    /* 30 */ NO_SOFTPWM,
    /* 31 */ NO_SOFTPWM,
    /* 32 */ NO_SOFTPWM,
    /* 33 */ NO_SOFTPWM,
    /* 34 */ NO_SOFTPWM,
    /* 35 */ NO_SOFTPWM,

    /* 36 */ NO_SOFTPWM,
    /* 37 */ NO_SOFTPWM,
    /* 38 */ NO_SOFTPWM,
    /* 39 */ NO_SOFTPWM,
    /* 40 */ NO_SOFTPWM,
    /* 41 */ NO_SOFTPWM,

    /* 42 */ NO_SOFTPWM,
};