//*******************************************************************************
//*	
//*	                             Font handling for
//*	                             Sub-Processing 
//*                        for TouchShield library
//*	         by inthebitz @ antipastohw.blogspot.com & liquidware.com
//*	
//*******************************************************************************
//*	Jan 21,	2009	<MLS> Started working on large fonts
//*	Nov 11,	2009	<TWH> Created Tahoma based font w/ variable sizing & Anti-Aliasing
//*	Nov 11,	2009	<TWH> Variable sizing means proportional spacing
//*	Nov 25,	2009	<TWH> Added Tahoma Bold support
//*	Nov 25,	2009	<TWH> Added support for rendering all 3 fonts
//*	Jan  9,	2009	<TWH/MLS> Merging TWHs Tahoma fonts
//*	Jan  9,	2009	<MLS> added _ENABLE_TAHOMA_FONTS_
//*******************************************************************************


//*******************************************************************************
//*	PREPROCESSOR DIRECTIVES
//*******************************************************************************

#include	<avr/io.h>
#include	<avr/pgmspace.h>

#include	"HardwareDef.h"
#include	"graphics.h"
#include	"font.h"
#include	"binary.h"

COLOR alphaBlend(COLOR forecolor, COLOR backcolor, int opacity);
int alphaBlendVal(float fgcolor, float bgcolor, float a);


#ifdef	_ENABLE_XLARGE_NUMBERS_

//*******************************************************************************
//*X-Bitmap style storage of a xlarge number
//*******************************************************************************
//#define		kXLargeNum_Width		56
//#define		kXLargeNum_BytesperRow	7
#define		kXLargeNum_Width		48
#define		kXLargeNum_BytesperRow	6
#define		kXLargeNum_Height		82
#define		kXLargeNum_BytesPerDef	492
const unsigned char gXLarge_nums[] PROGMEM= {

//zero
   0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 
   0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x07, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 
   0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 

//one
   0xF8, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 0xF8, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 
   0xFF, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 
   0xFF, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 
   0xFF, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 
   0xFF, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 
   0xF8, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x80, 0x0F, 
   0x00, 0x00, 0xFC, 0x0F, 0x80, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0xC0, 0x0F, 
   0x00, 0x00, 0xFC, 0x0F, 0xC0, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 
   0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 
   0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 
   0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 
   0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 
   0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 
   0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 
   0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 
   0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 
   0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 
   0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 
   0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 
   0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 0x00, 0x00, 0xFC, 0x0F, 0xE0, 0x1F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F,

//two
   0xFC, 0xFF, 0xFF, 0xFF, 0x7F, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 
   0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 
   0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07,

 //three
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 
   0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0xF8, 0xFF, 0xFF, 0xFF, 0x3F, 
   0x00, 0xF8, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0xFC, 0xFF, 0xFF, 0xFF, 0x3F, 
   0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x1F, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x0F, 
   0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x0F, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x0F, 
   0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x1F, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x1F, 
   0x00, 0xFC, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0xF8, 0xFF, 0xFF, 0xFF, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xC0, 0x3F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x01,

//four
   0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0xFE, 0x01, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x07, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x07, 0x00, 0x00, 0x1F, 0x00, 0xFF, 0x07, 0x00, 0x80, 0x7F, 0x00, 
   0xFF, 0x07, 0x00, 0x80, 0x7F, 0x00, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 
   0xFF, 0x07, 0x00, 0xC0, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 
   0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 
   0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 
   0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 
   0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 
   0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 
   0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 
   0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 
   0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 
   0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 
   0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 
   0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 
   0x00, 0x00, 0x00, 0xC0, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x80, 0x7F, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00,

//five
   0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x07, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x0F, 
   0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x0F, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x3F, 
   0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x3F, 
   0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x3F, 
   0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x0F, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x07, 
   0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x07, 0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 
   0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 
   0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 
   0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 
   0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 
   0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 
   0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 
   0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 
   0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 
   0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 
   0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 
   0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 
   0x00, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFE, 0xFF, 0xFF, 0x3F, 0x00, 
   0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x01, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x01, 
   0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x07, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x0F, 
   0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x0F, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x0F, 
   0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x3F, 
   0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0xFE, 0xFF, 0xFF, 0xFF, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x3F, 
   0x7E, 0x00, 0x00, 0x00, 0xF8, 0x3F, 0xFF, 0x01, 0x00, 0x00, 0xF8, 0x3F, 
   0xFF, 0x01, 0x00, 0x00, 0xF8, 0x3F, 0xFF, 0x0F, 0x00, 0x00, 0xF8, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 
   0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 
   0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0x00, 0xF8, 0xFF, 0xFF, 0x3F, 0x00, 
   0x00, 0xF8, 0xFF, 0xFF, 0x3F, 0x00, 0x00, 0xF8, 0xFF, 0xFF, 0x3F, 0x00,

//six
   0xFC, 0x1F, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x1F, 0x00, 0x00, 0x00, 0x00, 
   0xFE, 0x1F, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x1F, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x1F, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x1F, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 
   0xFF, 0x03, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F,

//seven
   0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0x01, 0x00, 0x00, 0xF0, 0x3F, 
   0x7F, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x7F, 0x00, 0x00, 0x00, 0xF0, 0x3F, 
   0x7E, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xFC, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xFC, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 
   0x00, 0x00, 0x00, 0x80, 0xFF, 0x1F, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x1F, 
   0x00, 0x00, 0x00, 0xE0, 0xFF, 0x07, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x03, 
   0x00, 0x00, 0x00, 0xF0, 0xFF, 0x03, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x01, 
   0x00, 0x00, 0x00, 0xFE, 0x7F, 0x00, 0x00, 0x00, 0x80, 0xFF, 0x7F, 0x00, 
   0x00, 0x00, 0x80, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0xC0, 0xFF, 0x0F, 0x00, 
   0x00, 0x00, 0xE0, 0xFF, 0x0F, 0x00, 0x00, 0x00, 0xF0, 0xFF, 0x03, 0x00, 
   0x00, 0x00, 0xF0, 0xFF, 0x03, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x7F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x7F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x1F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x0F, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x00, 0x00, 
   0x00, 0x00, 0xF8, 0x03, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x01, 0x00, 0x00,

//eight
   0x00, 0xF0, 0xFF, 0xFF, 0x03, 0x00, 0x00, 0xF8, 0xFF, 0xFF, 0x07, 0x00, 
   0x00, 0xF8, 0xFF, 0xFF, 0x07, 0x00, 0x00, 0xFC, 0xFF, 0xFF, 0x0F, 0x00, 
   0x00, 0xFC, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 0xFC, 0xFF, 0xFF, 0x0F, 0x00, 
   0x00, 0xFC, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 0xFC, 0xFF, 0xFF, 0x0F, 0x00, 
   0x00, 0xFC, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 0xFC, 0xFF, 0xFF, 0x0F, 0x00, 
   0x00, 0xFC, 0xFF, 0xFF, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 
   0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 
   0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 
   0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 
   0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 
   0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 
   0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 
   0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 
   0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 
   0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 
   0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 
   0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 
   0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 0x00, 0xFC, 0x0F, 0xFC, 0x0F, 0x00, 
   0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 
   0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 
   0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0x01,

//nine
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xE0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xE0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xE0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xE0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xE0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xE0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xE0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xE0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xE0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xE0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xE0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xE0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xE0, 0x3F, 
   0xFF, 0x03, 0x00, 0x00, 0xE0, 0x3F, 0xFF, 0x03, 0x00, 0x00, 0xE0, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xFE, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 
   0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x1F, 
   0x00, 0x00, 0x00, 0x00, 0xFE, 0x1F, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x1F,

//period
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0xFF, 0x00, 
   0x00, 0x00, 0x00, 0xFC, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFE, 0xFF, 0x01, 
   0x00, 0x00, 0x80, 0xFF, 0xFF, 0x03, 0x00, 0x00, 0x80, 0xFF, 0xFF, 0x03, 
   0x00, 0x00, 0x80, 0xFF, 0xFF, 0x03, 0x00, 0x00, 0x80, 0xFF, 0xFF, 0x03, 
   0x00, 0x00, 0x80, 0xFF, 0xFF, 0x03, 0x00, 0x00, 0x80, 0xFF, 0xFF, 0x03, 
   0x00, 0x00, 0x80, 0xFF, 0xFF, 0x03, 0x00, 0x00, 0x80, 0xFF, 0xFF, 0x03, 
   0x00, 0x00, 0x80, 0xFF, 0xFF, 0x03, 0x00, 0x00, 0x80, 0xFF, 0xFF, 0x03, 
   0x00, 0x00, 0x80, 0xFF, 0xFF, 0x03, 0x00, 0x00, 0x80, 0xFF, 0xFF, 0x03, 
   0x00, 0x00, 0x00, 0xFE, 0xFF, 0x01, 0x00, 0x00, 0x00, 0xFE, 0xFF, 0x01, 
   0x00, 0x00, 0x00, 0xFC, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

//space
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

//negative sign
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xFC, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 
   0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0x01, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};







//*******************************************************************************
//*	the data is only defined for digits
void	dispPutXLargeNum(unsigned char digit, unsigned int x_pos,unsigned int y_pos,COLOR fc, COLOR bc)
{
//unsigned int	shifted,on_off,letter;
unsigned int	xx;
unsigned int	ii;
unsigned short	bitData;
unsigned char	digitIndex;
unsigned int	tableIndex;
unsigned int	row;
unsigned int	clmn;


	//*	get the index into the table
	//*	we have to use the case statement because of the special chars at the end of the table
	switch (digit)
	{
		case '.':	digitIndex	=	10;	break;
		case ' ':	digitIndex	=	11;	break;
		case '-':	digitIndex	=	12;	break;
		default:	digitIndex	=	digit & 0x0f;	break;
	}
	tableIndex	=	digitIndex * kXLargeNum_BytesPerDef;
	


	dispColor(fc);

	//*	step thru each row
	for (row=0; row < kXLargeNum_Height ;row++)
	{
		xx	=	0;
		for (clmn = 0; clmn < kXLargeNum_BytesperRow; clmn++)
		{
			//*							bass add     index for letter  (which row)                (which byte in row)
			bitData	=	pgm_read_byte(gXLarge_nums + tableIndex + (row * kXLargeNum_BytesperRow) + clmn);
			for (ii =0; ii< 8; ii++)
			{
				//oled_setXY(x_pos+x, y_pos+row);
				if (bitData & 0x01)
				{
					dispColor(fc);
					dispPixel(x_pos + xx, y_pos + row); //write the pixel
				}
				else
				{
					dispColor(bc);
					dispPixel(x_pos + xx, y_pos + row); //write the pixel
				}
				bitData	=	bitData >> 1;
				xx++;
			}
		}
	}
}


//*******************************************************************************
void	dispPutXLargeNumString(char * string, unsigned int x_pos, unsigned int y_pos, COLOR fc, COLOR bc)
{
	while(*string)
	{
		dispPutXLargeNum(*string++, x_pos, y_pos, fc, bc);
		x_pos	=	x_pos + kXLargeNum_Width;
	}
}

#endif





#ifdef	_ENABLE_LARGE_NUMBERS_

//////////////////////////////////////
/*! X-Bitmap style storage of a large number
	width: 16
	height: 23
*/
////////////////////////////////////
const unsigned char gLarge_nums[] PROGMEM = {
#define		kLargeNum_Width			16
#define		kLargeNum_BytesperRow	2
#define		kLargeNum_Height		23
#define		kLargeNum_BytesPerDef	46
//zero
   0xE0, 0x01, 0xFC, 0x0F, 0xFE, 0x1F, 0x0E, 0x1C, 0x07, 0x38, 0x07, 0x38, 
   0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 
   0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x07, 0x38, 
   0x07, 0x38, 0x0E, 0x1C, 0xFE, 0x1F, 0xFC, 0x0F, 0xE0, 0x01,
//one
   0x00, 0x06, 0x00, 0x07, 0x80, 0x07, 0xc0, 0x07, 0xe0, 0x07, 0x78, 0x07,
   0x3c, 0x07, 0x0c, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07,
   0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07,
   0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07,
//two
   0xe0, 0x03, 0xf8, 0x0f, 0xfc, 0x1f, 0x0e, 0x3c, 0x06, 0x38, 0x07, 0x70,
   0x00, 0x70, 0x00, 0x70, 0x00, 0x30, 0x00, 0x30, 0x00, 0x18, 0x00, 0x1c,
   0x00, 0x0e, 0x00, 0x07, 0x80, 0x03, 0xc0, 0x01, 0x60, 0x00, 0x38, 0x00,
   0x1c, 0x00, 0x0e, 0x00, 0xfe, 0x7f, 0xff, 0x7f, 0xff, 0x7f,
//three
   0xC0, 0x03, 0xF8, 0x0F, 0xFC, 0x3F, 0x1E, 0x38, 0x06, 0x70, 0x07, 0x70, 
   0x00, 0x70, 0x00, 0x30, 0x00, 0x38, 0x80, 0x0F, 0xC0, 0x0F, 0x40, 0x3E, 
   0x00, 0x70, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x07, 0x60, 
   0x06, 0x70, 0x0E, 0x78, 0xFC, 0x3F, 0xF8, 0x0F, 0xC0, 0x03,
//four
   0x00, 0x18, 0x00, 0x1C, 0x00, 0x1E, 0x00, 0x1E, 0x00, 0x1F, 0x80, 0x1F, 
   0x80, 0x1D, 0xC0, 0x1C, 0xE0, 0x1C, 0x70, 0x1C, 0x30, 0x1C, 0x18, 0x1C, 
   0x1C, 0x1C, 0x0E, 0x1C, 0x06, 0x1C, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0x7F, 
   0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x1C,
//five
   0xFC, 0x7F, 0xFC, 0x7F, 0xFC, 0x7F, 0x0C, 0x00, 0x0C, 0x00, 0x0E, 0x00, 
   0x0E, 0x00, 0xC6, 0x03, 0xF6, 0x1F, 0xFE, 0x3F, 0x0E, 0x78, 0x07, 0x70, 
   0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x07, 0x60, 
   0x06, 0x70, 0x0E, 0x38, 0xFC, 0x3F, 0xF8, 0x0F, 0xC0, 0x03,
//six
   0x80, 0x07, 0xF0, 0x1F, 0xF8, 0x3F, 0x3C, 0x70, 0x1C, 0x60, 0x0E, 0x60, 
   0x06, 0x00, 0x06, 0x00, 0x86, 0x07, 0xE7, 0x1F, 0xF7, 0x3F, 0x1F, 0x78, 
   0x0F, 0x70, 0x07, 0x60, 0x07, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 
   0x0E, 0x70, 0x1C, 0x78, 0xF8, 0x3F, 0xF0, 0x1F, 0xC0, 0x03,
//seven
   0xff, 0x7f, 0xff, 0x7f, 0xff, 0x7f, 0x00, 0x30, 0x00, 0x18, 0x00, 0x0c,
   0x00, 0x0e, 0x00, 0x06, 0x00, 0x03, 0x80, 0x03, 0x80, 0x01, 0xc0, 0x01,
   0xc0, 0x00, 0xc0, 0x00, 0xe0, 0x00, 0x60, 0x00, 0x70, 0x00, 0x70, 0x00,
   0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x38, 0x00, 0x38, 0x00,
//eight
   0xC0, 0x03, 0xF8, 0x0F, 0xFC, 0x3F, 0x1C, 0x38, 0x0E, 0x70, 0x0E, 0x70, 
   0x0E, 0x70, 0x0C, 0x30, 0x1C, 0x38, 0xF8, 0x1F, 0xF0, 0x0F, 0xF8, 0x1F, 
   0x1E, 0x38, 0x0E, 0x70, 0x07, 0x60, 0x07, 0x60, 0x07, 0x60, 0x07, 0x60, 
   0x06, 0x70, 0x1E, 0x78, 0xFC, 0x3F, 0xF8, 0x1F, 0xC0, 0x03,
//nine
   0xC0, 0x03, 0xF8, 0x0F, 0xFC, 0x1F, 0x1E, 0x38, 0x0E, 0x70, 0x06, 0x60, 
   0x07, 0x60, 0x07, 0x60, 0x07, 0x60, 0x07, 0x60, 0x0E, 0x70, 0x1E, 0x78, 
   0xFC, 0x6F, 0xF8, 0x67, 0xE0, 0x61, 0x00, 0x60, 0x00, 0x60, 0x07, 0x70, 
   0x06, 0x30, 0x0E, 0x38, 0xFC, 0x1F, 0xF8, 0x0F, 0xE0, 0x01,

//period
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00,

//space
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//neg
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x3f,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
    };


//*******************************************************************************
//*	the data is only defined for digits
void	dispPutLargeNum(unsigned char digit, unsigned int x_pos,unsigned int y_pos,COLOR fc, COLOR bc)
{
unsigned int	xx;
unsigned short	bitData;
unsigned char	digitIndex;
unsigned int	tableIndex;
unsigned int	row;
unsigned int	oneByte;


	//*	get the index into the table
	//*	we have to use the case statement because of the special chars at the end of the table
	switch (digit)
	{
		case '.':	digitIndex	=	10;	break;
		case ' ':	digitIndex	=	11;	break;
		case '-':	digitIndex	=	12;	break;
		default:	digitIndex	=	digit & 0x0f;	break;
	}
	tableIndex	=	digitIndex * kLargeNum_BytesPerDef;
	


	dispColor(fc);


	//*	the char is 16 bits wide, use a short to get 2 bytes
	for (row=0; row < kLargeNum_Height ;row++)
	{
		oneByte	=	pgm_read_byte(gLarge_nums + tableIndex + (row * kLargeNum_BytesperRow) + 1);
		bitData	=	oneByte << 8;
		bitData	+=	pgm_read_byte(gLarge_nums + tableIndex + (row * kLargeNum_BytesperRow));
		
		
		for (xx = 0; xx < kLargeNum_Width; xx++)
		{
			
			//oled_setXY(x_pos+x, y_pos+row);
			if (bitData & 0x01)
			{
				dispColor(fc);
				dispPixel(x_pos + xx, y_pos + row);		//write the pixel
			}
			else
			{
				dispColor(bc);
				dispPixel(x_pos + xx, y_pos + row);		//write the pixel
			}
			bitData	=	bitData >> 1;
		}
	}
}

//*******************************************************************************
void	dispPutLargeNumString(char * string, unsigned int x_pos, unsigned int y_pos, COLOR fc, COLOR bc)
{
	while(*string)
	{
		dispPutLargeNum(*string++, x_pos, y_pos, fc, bc);
		x_pos	=	x_pos + kLargeNum_Width;
	}
}
#endif


//*******************************************************************************
//* System Default font
//*******************************************************************************
//////////////////////////////////////////
/*! Our 5x7 Font that we normally use
*/
////////////////////////////////////////////
const unsigned char gFont_5x7[752] PROGMEM ={  

   B00000000, 
   B00000000, 
   B00000000, 
   B00000000, 
   B00000000, 
   B00000000, 
   B00000000,    //letter Space


   B00100000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B00000000, 
   B00100000,    //letter !

   B01010000, 
   B01010000, 
   B00000000, 
   B00000000, 
   B00000000, 
   B00000000, 
   B00000000,    //letter "

   B01010000, 
   B01010000, 
   B11111000, 
   B01010000, 
   B11111000, 
   B01010000, 
   B01010000,    //letter #

   B00100000, 
   B01111000, 
   B10100000, 
   B01110000, 
   B00101000, 
   B00110000, 
   B00100000,    //letter $

   B11000000, 
   B11001000, 
   B00010000, 
   B00100000, 
   B01000000, 
   B10011000, 
   B00011000,    //letter %


   B01000000, 
   B10100000, 
   B01000000, 
   B10100000, 
   B10010000, 
   B10001000, 
   B01110000,    //letter &

   B00010000, 
   B00010000, 
   B00100000, 
   B00000000, 
   B00000000, 
   B00000000, 
   B00000000,    //letter '

   B00100000, 
   B01000000, 
   B01000000, 
   B01000000, 
   B01000000, 
   B01000000, 
   B00100000,    //letter (

   B00010000, 
   B00001000, 
   B00001000, 
   B00001000, 
   B00001000, 
   B00001000, 
   B00010000,    //letter )

   B00000000, 
   B10001000, 
   B01010000, 
   B11111000, 
   B01010000, 
   B10001000, 
   B00000000,    //letter *

   B00000000, 
   B00100000, 
   B00100000, 
   B11111000, 
   B00100000, 
   B00100000, 
   B00000000,    //letter +

   B00000000, 
   B00000000, 
   B00000000, 
   B00000000, 
   B01000000, 
   B01000000, 
   B10000000,    //letter ,

   B00000000, 
   B00000000, 
   B00000000, 
   B11111000, 
   B00000000, 
   B00000000, 
   B00000000,    //letter -

   B00000000, 
   B00000000, 
   B00000000, 
   B00000000, 
   B00000000, 
   B11000000, 
   B11000000,   //letter .

   B00000000, 
   B00001000, 
   B00010000, 
   B00100000, 
   B01000000, 
   B10000000, 
   B00000000,   //letter /

   B01110000, 
   B10001000, 
   B10011000, 
   B10101000, 
   B11001000, 
   B10001000, 
   B01110000,   //letter 0
   
   B00100000, 
   B01100000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B01110000,   //letter 1 

   B01110000, 
   B00001000, 
   B00001000, 
   B01110000, 
   B10000000, 
   B10000000, 
   B11111000,   //letter 2

   B11110000, 
   B00001000, 
   B00001000, 
   B01110000, 
   B00001000, 
   B00001000, 
   B11110000,   //letter 3

   B00001000, 
   B00011000, 
   B00101000, 
   B01001000, 
   B11111000, 
   B00001000, 
   B00001000,   //letter 4

   B11111000, 
   B10000000, 
   B10000000, 
   B11110000, 
   B00001000, 
   B10001000, 
   B01110000,   //letter 5
   
   B01110000, 
   B10000000, 
   B10000000, 
   B11110000, 
   B10001000, 
   B10001000, 
   B01110000,   //letter 6

   B11111000, 
   B00001000, 
   B00001000, 
   B00010000, 
   B00100000, 
   B01000000, 
   B10000000,   //letter 7

   B01110000, 
   B10001000, 
   B10001000, 
   B01110000, 
   B10001000, 
   B10001000, 
   B01110000,   //letter 8
   
   B01110000, 
   B10001000, 
   B10001000, 
   B01111000, 
   B00010000, 
   B00100000, 
   B01000000,   //letter 9

   B00000000, 
   B00000000, 
   B01100000, 
   B01100000, 
   B00000000, 
   B01100000, 
   B01100000,    //letter :

   B00000000, 
   B00000000, 
   B01100000, 
   B01100000, 
   B00000000, 
   B00100000, 
   B01000000,    //letter ;

   B00010000, 
   B00100000, 
   B01000000, 
   B10000000, 
   B01000000, 
   B00100000, 
   B00010000,    //letter <

   B00000000, 
   B00000000, 
   B11111000, 
   B00000000, 
   B11111000, 
   B00000000, 
   B00000000,    //letter =

   B01000000, 
   B00100000, 
   B00010000, 
   B00001000, 
   B00010000, 
   B00100000, 
   B01000000,    //letter >

   B01110000, 
   B10001000, 
   B00001000, 
   B00110000, 
   B01000000, 
   B00000000, 
   B01000000,    //letter ?

   B00100000, 
   B00100000, 
   B01110000, 
   B11110000, 
   B11110000, 
   B11111000, 
   B11111000,    //letter @

//-----------------------------------Capital Letters
   B00100000, 
   B01011000, 
   B10001000, 
   B11111000, 
   B10001000, 
   B10001000, 
   B10001000,    //letter A 

   B11110000, 
   B10001000, 
   B10001000, 
   B11110000, 
   B10001000, 
   B10001000, 
   B11110000,    //letter B

   B01110000, 
   B10001000, 
   B10000000, 
   B10000000, 
   B10000000, 
   B10001000, 
   B01110000,    //letter C

   B11110000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B11110000,    //letter D

   B11111000, 
   B10000000, 
   B10000000, 
   B11110000, 
   B10000000, 
   B10000000, 
   B11111000,    //letter E

   B11111000, 
   B10000000, 
   B10000000, 
   B11110000, 
   B10000000, 
   B10000000, 
   B10000000,    //letter F

   B01110000, 
   B10001000, 
   B10000000, 
   B10000000, 
   B10011000, 
   B10001000, 
   B01111000,    //letter G

   B10001000, 
   B10001000, 
   B10001000, 
   B11111000, 
   B10001000, 
   B10001000, 
   B10001000,    //letter H

   B01110000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B01110000,    //letter I

   B11111000, 
   B00010000, 
   B00010000, 
   B00010000, 
   B10010000, 
   B10010000, 
   B01100000,    //letter J

   B10001000, 
   B10010000, 
   B10100000, 
   B11000000, 
   B10100000, 
   B10010000, 
   B10001000,    //letter K

   B10000000, 
   B10000000, 
   B10000000, 
   B10000000, 
   B10000000, 
   B10000000, 
   B11111000,    //letter L

   B10001000, 
   B11011000, 
   B10101000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B10001000,    //letter M

   B10001000, 
   B11001000, 
   B10101000, 
   B10011000, 
   B10001000, 
   B10001000, 
   B10001000,    //letter N

   B01110000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B01110000,    //letter O

   B11110000, 
   B10001000, 
   B10001000, 
   B11110000, 
   B10000000, 
   B10000000, 
   B10000000,    //letter P

   B01110000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B10101000, 
   B10011000, 
   B01111000,    //letter Q

   B11110000, 
   B10001000, 
   B10001000, 
   B11110000, 
   B10100000, 
   B10010000, 
   B10001000,    //letter R

   B01111000, 
   B10000000, 
   B10000000, 
   B01110000, 
   B00001000, 
   B00001000, 
   B11110000,    //letter S

   B11111000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B00100000,    //letter T

   B10001000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B01110000,    //letter U

   B10001000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B01010000, 
   B00100000,    //letter V

   B10001000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B10101000, 
   B11011000, 
   B10001000,    //letter W

   B10001000, 
   B10001000, 
   B01010000, 
   B00100000, 
   B01010000, 
   B10001000, 
   B10001000,    //letter X

   B10001000, 
   B10001000, 
   B10001000, 
   B01010000, 
   B00100000, 
   B00100000, 
   B00100000,    //letter Y

   B11111000, 
   B00001000, 
   B00010000, 
   B00100000, 
   B01000000, 
   B10000000, 
   B11111000,    //letter Z
//-----------------------------------End capital letters
   B11100000, 
   B10000000, 
   B10000000, 
   B10000000, 
   B10000000, 
   B10000000, 
   B11100000,    //letter [

   B00000000, 
   B10000000, 
   B01000000, 
   B00100000, 
   B00010000, 
   B00001000, 
   B00000000,    //letter

   B00111000, 
   B00001000, 
   B00001000, 
   B00001000, 
   B00001000, 
   B00001000, 
   B00111000,    //letter ]

   B00100000, 
   B01010000, 
   B10001000, 
   B00000000, 
   B00000000, 
   B00000000, 
   B00000000,    //letter ^

   B00000000, 
   B00000000, 
   B00000000, 
   B00000000, 
   B00000000, 
   B00000000, 
   B11111000,    //letter _

   B00010000, 
   B00010000, 
   B00001000, 
   B00000000, 
   B00000000, 
   B00000000, 
   B00000000,    //letter '

   B00000000, 
   B00000000, 
   B01110000, 
   B10001000, 
   B10001000, 
   B10011000, 
   B01101000,    //letter a

   B10000000, 
   B10000000, 
   B11110000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B11110000,    //letter b

   B00000000, 
   B00000000, 
   B01111000, 
   B10000000, 
   B10000000, 
   B10000000, 
   B01111000,    //letter c

   B00001000, 
   B00001000, 
   B01111000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B01111000,    //letter d

   B00000000, 
   B00000000, 
   B01110000, 
   B10001000, 
   B11111000, 
   B10000000, 
   B01111000,    //letter e

   B00010000, 
   B00101000, 
   B01110000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B00100000,    //letter f

   B00000000, 
   B00000000, 
   B01110000, 
   B10001000, 
   B01111000, 
   B00001000, 
   B01110000,    //letter g

   B10000000, 
   B10000000, 
   B11110000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B10001000,    //letter h

   B00100000, 
   B00000000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B00100000,    //letter i

   B00100000, 
   B00000000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B10100000, 
   B01000000,    //letter j

   B10000000, 
   B10000000, 
   B10001000, 
   B10010000, 
   B10100000, 
   B11010000, 
   B10001000,    //letter k

   B00100000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B00100000,    //letter l

   B00000000, 
   B00000000, 
   B11010000, 
   B10101000, 
   B10101000, 
   B10101000, 
   B10101000,    //letter m

   B00000000, 
   B00000000, 
   B10110000, 
   B11001000, 
   B10001000, 
   B10001000, 
   B10001000,    //letter n

   B00000000, 
   B00000000, 
   B01110000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B01110000,    //letter o

   B00000000, 
   B00000000, 
   B11110000, 
   B10001000, 
   B11110000, 
   B10000000, 
   B10000000,    //letter p

   B00000000, 
   B00000000, 
   B01111000, 
   B10001000, 
   B01111000, 
   B00001000, 
   B00001000,    //letter q

   B00000000, 
   B00000000, 
   B10110000, 
   B11001000, 
   B10000000, 
   B10000000, 
   B10000000,    //letter r

   B00000000, 
   B00000000, 
   B01111000, 
   B10000000, 
   B01110000, 
   B00001000, 
   B11110000,    //letter s

   B00100000, 
   B00100000, 
   B01110000, 
   B00100000, 
   B00100000, 
   B00100000, 
   B00110000,    //letter t

   B00000000, 
   B00000000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B10011000, 
   B01101000,    //letter u

   B00000000, 
   B00000000, 
   B10001000, 
   B10001000, 
   B10001000, 
   B01010000, 
   B00100000,    //letter v

   B00000000, 
   B00000000, 
   B10001000, 
   B10001000, 
   B10101000, 
   B10101000, 
   B01010000,    //letter w

   B00000000, 
   B00000000, 
   B10001000, 
   B01010000, 
   B00100000, 
   B01010000, 
   B10001000,    //letter x

   B00000000, 
   B00000000, 
   B10001000, 
   B10001000, 
   B11111000, 
   B00001000, 
   B01110000,    //letter y

   B00000000, 
   B00000000, 
   B11111000, 
   B00010000, 
   B00100000, 
   B01000000, 
   B11111000,    //letter z

   B00100000, 
   B01000000, 
   B01000000, 
   B10000000, 
   B01000000, 
   B01000000, 
   B00100000,    //letter {

   B00100000, 
   B00100000, 
   B00100000, 
   B00000000, 
   B00100000, 
   B00100000, 
   B00100000,    //letter |

   B00100000, 
   B00010000, 
   B00010000, 
   B00001000, 
   B00010000, 
   B00010000, 
   B00100000,    //letter }

   B00000000, 
   B00000000, 
   B01010000, 
   B10100000, 
   B00000000, 
   B00000000, 
   B00000000    //letter ~ 

};

#ifdef _ENABLE_TAHOMA_FONTS_
//*******************************************************************************
//* Tahoma Regular
//*******************************************************************************
const unsigned char font1_sizes[94] PROGMEM = {
	0x02, 0x05, 0x08, 0x07, 0x0C, 0x0A, 0x02, 0x05, 0x04, 0x07, 0x09, 0x03, 0x06, 0x02, 0x06, 
	0x07, 0x05, 0x06, 0x06, 0x07, 0x06, 0x07, 0x06, 0x07, 0x07, 0x04, 0x04, 0x07, 0x08, 0x07, 
	0x05, 0x0B, 0x08, 0x07, 0x08, 0x08, 0x07, 0x07, 0x08, 0x08, 0x05, 0x04, 0x08, 0x07, 0x09, 
	0x08, 0x09, 0x07, 0x09, 0x08, 0x07, 0x08, 0x08, 0x08, 0x0C, 0x08, 0x07, 0x06, 0x05, 0x05, 
	0x04, 0x08, 0x08, 0x02, 0x06, 0x07, 0x07, 0x07, 0x07, 0x05, 0x07, 0x06, 0x02, 0x04, 0x07, 
	0x02, 0x0A, 0x06, 0x07, 0x07, 0x07, 0x05, 0x06, 0x05, 0x05, 0x07, 0x0A, 0x06, 0x07, 0x05, 
	0x06, 0x02, 0x07, 0x08
};


const unsigned char font1_data[9177] PROGMEM = {
	// !
	0x0,0x0,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x0,0x0,
	0x14,0x63,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	// "
	0x19,0x64,0x7,0x56,0x2F,
	0x12,0x64,0x1,0x4F,0x28,
	0xB,0x5E,0x0,0x48,0x21,
	0x4,0x57,0x0,0x41,0x19,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	// #
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x1,0x50,0x0,0x28,0x2A,0x0,
	0x0,0x0,0x19,0x3A,0x0,0x47,0xB,0x0,
	0x1D,0x52,0x5C,0x57,0x52,0x60,0x52,0x2E,
	0x0,0x0,0x4C,0x5,0x16,0x3B,0x0,0x0,
	0x0,0x0,0x50,0x0,0x2A,0x28,0x0,0x0,
	0x0,0xE,0x42,0x0,0x3D,0x14,0x0,0x0,
	0x61,0x62,0x62,0x61,0x64,0x61,0x4F,0x0,
	0x0,0x3F,0x12,0xA,0x47,0x0,0x0,0x0,
	0x2,0x4F,0x0,0x2B,0x26,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// $
	0x0,0x0,0x14,0x64,0x2,0x0,0x0,
	0x0,0x0,0x22,0x64,0x19,0x9,0x0,
	0x0,0x3C,0x58,0x64,0x47,0x5E,0x40,
	0xC,0x64,0x1F,0x64,0x2,0x3,0x16,
	0xF,0x64,0x22,0x64,0x2,0x0,0x0,
	0x0,0x46,0x5E,0x64,0x37,0x19,0x0,
	0x0,0x0,0x25,0x64,0x35,0x5A,0x3D,
	0x0,0x0,0x14,0x64,0x2,0x1C,0x62,
	0x14,0x26,0x17,0x64,0x7,0x3A,0x48,
	0xD,0x4C,0x60,0x64,0x58,0x37,0x5,
	0x0,0x0,0x14,0x64,0x2,0x0,0x0,
	0x0,0x0,0x14,0x64,0x2,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// %
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x2F,0x5F,0x5B,0x21,0x0,0x0,0x0,0x46,0x19,0x0,0x0,
	0x8,0x63,0x17,0x29,0x59,0x0,0x0,0x1D,0x42,0x0,0x0,0x0,
	0x13,0x64,0x4,0x16,0x64,0x0,0x2,0x52,0xB,0x0,0x0,0x0,
	0x8,0x63,0x15,0x28,0x58,0x0,0x2F,0x30,0x0,0x0,0x0,0x0,
	0x0,0x2E,0x5D,0x5A,0x20,0xB,0x52,0x3,0x27,0x53,0x51,0x1A,
	0x0,0x0,0x0,0x0,0x0,0x41,0x1E,0x7,0x62,0x11,0x24,0x56,
	0x0,0x0,0x0,0x0,0x18,0x47,0x0,0x13,0x64,0x3,0x16,0x64,
	0x0,0x0,0x0,0x1,0x4F,0xF,0x0,0x9,0x64,0x15,0x29,0x59,
	0x0,0x0,0x0,0x2A,0x35,0x0,0x0,0x0,0x31,0x5F,0x5C,0x22,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// &
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x20,0x55,0x62,0x54,0x1C,0x0,0x0,0x0,0x0,
	0x9,0x62,0x21,0x2,0x33,0x5E,0x0,0x0,0x0,0x0,
	0xD,0x64,0xB,0x0,0x1C,0x59,0x0,0x0,0x0,0x0,
	0x0,0x3C,0x55,0x2B,0x4A,0x18,0x6,0x1F,0x0,0x0,
	0x0,0x2A,0x46,0x40,0x40,0x3,0x14,0x63,0x0,0x0,
	0x5,0x61,0xE,0x1,0x40,0x50,0x24,0x53,0x0,0x0,
	0x12,0x64,0x8,0x0,0x1,0x40,0x64,0x35,0x0,0x0,
	0x4,0x5D,0x3B,0x5,0x6,0x37,0x52,0x5E,0x14,0x0,
	0x0,0x14,0x4D,0x61,0x5B,0x37,0x3,0x2E,0x5D,0x13,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// '
	0x1D,0x64,
	0x17,0x61,
	0x10,0x5B,
	0x9,0x54,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	// (
	0x0,0x0,0x10,0x5F,0x22,
	0x0,0x1,0x4F,0x38,0x0,
	0x0,0x23,0x5D,0x5,0x0,
	0x0,0x4B,0x38,0x0,0x0,
	0x3,0x62,0x1B,0x0,0x0,
	0xF,0x64,0xA,0x0,0x0,
	0x13,0x64,0x4,0x0,0x0,
	0xF,0x64,0x9,0x0,0x0,
	0x4,0x62,0x1A,0x0,0x0,
	0x0,0x4C,0x38,0x0,0x0,
	0x0,0x22,0x5D,0x5,0x0,
	0x0,0x0,0x4E,0x37,0x0,
	0x0,0x0,0xE,0x5E,0x21,
	// )
	0x32,0x57,0x6,0x0,
	0x0,0x48,0x3E,0x0,
	0x0,0x10,0x63,0x10,
	0x0,0x0,0x49,0x38,
	0x0,0x0,0x2C,0x54,
	0x0,0x0,0x1B,0x62,
	0x0,0x0,0x16,0x64,
	0x0,0x0,0x1B,0x62,
	0x0,0x0,0x2C,0x54,
	0x0,0x0,0x49,0x38,
	0x0,0xF,0x63,0x10,
	0x0,0x47,0x3E,0x0,
	0x31,0x57,0x6,0x0,
	// *
	0x0,0x0,0x14,0x64,0x3,0x0,0x0,
	0x2A,0x35,0x17,0x64,0xA,0x40,0x1C,
	0x0,0x24,0x51,0x64,0x4A,0x1A,0x0,
	0x0,0x23,0x51,0x64,0x4A,0x1A,0x0,
	0x2A,0x35,0x17,0x64,0xA,0x40,0x1C,
	0x0,0x0,0x14,0x64,0x3,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// +
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x14,0x64,0x3,0x0,0x0,0x0,
	0x0,0x0,0x0,0x14,0x64,0x3,0x0,0x0,0x0,
	0x0,0x0,0x0,0x14,0x64,0x3,0x0,0x0,0x0,
	0x27,0x61,0x61,0x62,0x64,0x61,0x61,0x61,0x18,
	0x0,0x0,0x0,0x14,0x64,0x3,0x0,0x0,0x0,
	0x0,0x0,0x0,0x14,0x64,0x3,0x0,0x0,0x0,
	0x0,0x0,0x0,0x14,0x64,0x3,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// ,
	0x0,0x0,0x0,
	0x0,0x0,0x0,
	0x0,0x0,0x0,
	0x0,0x0,0x0,
	0x0,0x0,0x0,
	0x0,0x0,0x0,
	0x0,0x0,0x0,
	0x0,0x0,0x0,
	0x0,0x0,0x0,
	0x0,0x37,0x5C,
	0x0,0x53,0x33,
	0xB,0x61,0x9,
	0x27,0x3E,0x0,
	// -
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x63,0x63,0x63,0x63,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	// .
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x11,0x55,
	0x14,0x64,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	// /
	0x0,0x0,0x0,0x0,0x3F,0x2E,
	0x0,0x0,0x0,0x2,0x5D,0xE,
	0x0,0x0,0x0,0x1B,0x52,0x0,
	0x0,0x0,0x0,0x3C,0x32,0x0,
	0x0,0x0,0x1,0x5B,0x11,0x0,
	0x0,0x0,0x18,0x55,0x0,0x0,
	0x0,0x0,0x38,0x35,0x0,0x0,
	0x0,0x0,0x57,0x15,0x0,0x0,
	0x0,0x14,0x59,0x0,0x0,0x0,
	0x0,0x34,0x38,0x0,0x0,0x0,
	0x0,0x54,0x18,0x0,0x0,0x0,
	0x4,0x31,0x1,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	// 0
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x8,0x44,0x60,0x5D,0x38,0x1,
	0x0,0x43,0x45,0x5,0xB,0x52,0x2D,
	0x3,0x62,0x15,0x0,0x0,0x28,0x50,
	0xF,0x64,0x7,0x0,0x0,0x19,0x60,
	0x13,0x64,0x4,0x0,0x0,0x15,0x64,
	0xF,0x64,0x6,0x0,0x0,0x19,0x60,
	0x2,0x61,0x14,0x0,0x0,0x28,0x51,
	0x0,0x41,0x45,0x5,0xA,0x52,0x2E,
	0x0,0x7,0x44,0x60,0x5D,0x3A,0x2,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// 1
	0x0,0x0,0x0,0x0,0x0,
	0x1,0x1B,0x64,0x3,0x0,
	0x5B,0x63,0x64,0x3,0x0,
	0x0,0x14,0x64,0x3,0x0,
	0x0,0x14,0x64,0x3,0x0,
	0x0,0x14,0x64,0x3,0x0,
	0x0,0x14,0x64,0x3,0x0,
	0x0,0x14,0x64,0x3,0x0,
	0x0,0x14,0x64,0x3,0x0,
	0x55,0x5E,0x64,0x5D,0x41,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	// 2
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x34,0x59,0x62,0x50,0x13,0x0,
	0x2C,0xD,0x2,0x39,0x54,0x0,
	0x0,0x0,0x0,0x18,0x64,0x0,
	0x0,0x0,0x0,0x2C,0x54,0x0,
	0x0,0x0,0x9,0x5C,0x26,0x0,
	0x0,0x3,0x4D,0x3C,0x0,0x0,
	0x2,0x46,0x41,0x1,0x0,0x0,
	0x45,0x3E,0x1,0x0,0x0,0x0,
	0x64,0x63,0x63,0x63,0x63,0x63,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	// 3
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x18,0x4C,0x5F,0x62,0x52,0x20,
	0x16,0x17,0x3,0x2,0x2D,0x60,
	0x0,0x0,0x0,0x7,0x37,0x47,
	0x0,0x0,0x49,0x64,0x46,0x3,
	0x0,0x0,0x0,0x7,0x43,0x42,
	0x0,0x0,0x0,0x0,0x18,0x62,
	0x0,0x0,0x0,0x0,0x1D,0x60,
	0x33,0x1D,0x3,0xB,0x4F,0x3C,
	0x2A,0x54,0x62,0x5E,0x3C,0x4,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	// 4
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x3B,0x64,0x3,
	0x0,0x0,0x0,0x2D,0x57,0x64,0x3,
	0x0,0x0,0x1F,0x52,0x1A,0x64,0x3,
	0x0,0x15,0x57,0xD,0x14,0x64,0x3,
	0x8,0x57,0x16,0x0,0x14,0x64,0x3,
	0x14,0x62,0x61,0x61,0x62,0x64,0x61,
	0x0,0x0,0x0,0x0,0x14,0x64,0x3,
	0x0,0x0,0x0,0x0,0x14,0x64,0x3,
	0x0,0x0,0x0,0x0,0x14,0x64,0x3,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// 5
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x63,0x63,0x63,0x60,
	0x14,0x64,0x3,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,
	0x14,0x64,0x62,0x5F,0x45,0xA,
	0x4,0xA,0x0,0x9,0x46,0x49,
	0x0,0x0,0x0,0x0,0x18,0x62,
	0x0,0x0,0x0,0x0,0x1E,0x5E,
	0x2D,0x1B,0x2,0xA,0x4E,0x3A,
	0x2D,0x57,0x62,0x5D,0x39,0x3,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	// 6
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x14,0x47,0x5E,0x62,0x17,
	0x0,0x16,0x59,0x1F,0x3,0x4,0x4,
	0x0,0x4C,0x23,0x0,0x0,0x0,0x0,
	0x6,0x64,0x43,0x5C,0x5F,0x45,0x9,
	0x11,0x64,0x1D,0x2,0x7,0x46,0x47,
	0x11,0x64,0x5,0x0,0x0,0x19,0x62,
	0x5,0x63,0x16,0x0,0x0,0x1B,0x5D,
	0x0,0x41,0x4B,0x7,0x8,0x4A,0x39,
	0x0,0x6,0x41,0x5F,0x5E,0x39,0x3,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// 7
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x63,0x63,0x63,0x63,0x63,0x64,
	0x0,0x0,0x0,0x0,0x27,0x56,
	0x0,0x0,0x0,0x4,0x59,0x23,
	0x0,0x0,0x0,0x2F,0x52,0x0,
	0x0,0x0,0x7,0x5E,0x1D,0x0,
	0x0,0x0,0x37,0x4C,0x0,0x0,
	0x0,0xC,0x61,0x17,0x0,0x0,
	0x0,0x3F,0x46,0x0,0x0,0x0,
	0x12,0x62,0x12,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	// 8
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x15,0x4C,0x61,0x5F,0x47,0xF,
	0x6,0x5E,0x2B,0x3,0x7,0x3D,0x54,
	0x10,0x64,0xC,0x0,0x0,0x19,0x5F,
	0x0,0x46,0x58,0x2A,0xE,0x48,0x30,
	0x0,0x1D,0x55,0x41,0x5F,0x57,0xE,
	0x5,0x5F,0x15,0x0,0x5,0x40,0x53,
	0x11,0x64,0x7,0x0,0x0,0x18,0x64,
	0x3,0x5B,0x3C,0x6,0x8,0x43,0x49,
	0x0,0x12,0x4B,0x61,0x5F,0x41,0x8,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// 9
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x9,0x43,0x60,0x5C,0x36,0x1,
	0x0,0x4C,0x3E,0x4,0xE,0x56,0x2F,
	0xD,0x64,0xC,0x0,0x0,0x27,0x55,
	0x10,0x64,0x7,0x0,0x0,0x17,0x62,
	0x2,0x59,0x37,0x4,0x4,0x2B,0x62,
	0x0,0x12,0x4D,0x60,0x5A,0x44,0x55,
	0x0,0x0,0x0,0x0,0x0,0x2B,0x37,
	0x0,0x6,0x2,0x4,0x23,0x54,0x9,
	0x0,0x27,0x63,0x5D,0x42,0xD,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// :
	0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,
	0x0,0x14,0x64,0x3,
	0x0,0x11,0x55,0x2,
	0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,
	0x0,0x11,0x55,0x2,
	0x0,0x14,0x64,0x3,
	0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,
	// ;
	0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,
	0x0,0x14,0x64,0x3,
	0x0,0x11,0x55,0x2,
	0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,
	0x0,0x0,0x2A,0x10,
	0x0,0xF,0x64,0xD,
	0x0,0x26,0x4E,0x0,
	0x0,0x3E,0x2C,0x0,
	0x0,0x54,0xA,0x0,
	// <
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x18,
	0x0,0x0,0x0,0x2,0x23,0x50,0x53,
	0x0,0x6,0x2E,0x59,0x48,0x1B,0x0,
	0x39,0x5C,0x3D,0x10,0x0,0x0,0x0,
	0x3E,0x5D,0x39,0xD,0x0,0x0,0x0,
	0x0,0x9,0x33,0x5B,0x44,0x17,0x0,
	0x0,0x0,0x0,0x4,0x28,0x54,0x4F,
	0x0,0x0,0x0,0x0,0x0,0x0,0x1D,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// =
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x4C,0x61,0x61,0x61,0x61,0x61,0x61,0x17,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x4D,0x63,0x63,0x63,0x63,0x63,0x63,0x17,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// >
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x18,0x0,0x0,0x0,0x0,0x0,0x0,
	0x53,0x50,0x23,0x2,0x0,0x0,0x0,
	0x0,0x1C,0x48,0x58,0x2E,0x6,0x0,
	0x0,0x0,0x0,0x10,0x3D,0x5C,0x39,
	0x0,0x0,0x0,0xD,0x39,0x5D,0x3E,
	0x0,0x17,0x44,0x5B,0x33,0x9,0x0,
	0x4F,0x54,0x28,0x4,0x0,0x0,0x0,
	0x1D,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// ?
	0x0,0x0,0x0,0x0,0x0,
	0x33,0x5B,0x62,0x51,0x14,
	0x21,0xC,0x3,0x38,0x55,
	0x0,0x0,0x0,0x18,0x63,
	0x0,0x0,0x0,0x39,0x4D,
	0x0,0x2,0x38,0x5D,0x12,
	0x0,0x14,0x64,0x10,0x0,
	0x0,0x11,0x55,0x2,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x14,0x63,0x3,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	// @
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x25,0x4E,0x5F,0x60,0x52,0x2E,0x2,0x0,
	0x0,0x2,0x43,0x52,0x1C,0x3,0x3,0x18,0x4F,0x4A,0x2,
	0x0,0x33,0x54,0x18,0x51,0x61,0x50,0x64,0x6,0x57,0x2D,
	0x2,0x5E,0x21,0x57,0x32,0x2,0x20,0x64,0x2,0x2C,0x53,
	0x10,0x64,0x18,0x64,0x5,0x0,0x14,0x64,0x2,0x18,0x62,
	0x10,0x64,0x18,0x64,0x7,0x0,0x14,0x64,0x2,0x18,0x5F,
	0x3,0x60,0x1E,0x5A,0x38,0x12,0x3A,0x64,0x2,0x28,0x41,
	0x0,0x3A,0x4E,0x18,0x4B,0x4E,0x29,0x54,0x45,0x4B,0xC,
	0x0,0x5,0x4E,0x4C,0x18,0x2,0x1,0xA,0x0,0x0,0x0,
	0x0,0x0,0x3,0x2F,0x52,0x60,0x60,0x4C,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// A
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x7,0x62,0x55,0x0,0x0,0x0,
	0x0,0x0,0x29,0x4D,0x60,0x14,0x0,0x0,
	0x0,0x0,0x4C,0x24,0x40,0x38,0x0,0x0,
	0x0,0xC,0x5E,0x4,0x1A,0x5A,0x1,0x0,
	0x0,0x2F,0x3E,0x0,0x0,0x58,0x1A,0x0,
	0x0,0x53,0x60,0x5D,0x5D,0x62,0x3E,0x0,
	0x12,0x5D,0xB,0xB,0xB,0x1C,0x5E,0x3,
	0x35,0x41,0x0,0x0,0x0,0x0,0x5B,0x21,
	0x58,0x23,0x0,0x0,0x0,0x0,0x3E,0x44,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// B
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x63,0x63,0x60,0x4E,0x16,
	0x14,0x64,0x3,0x0,0x5,0x38,0x58,
	0x14,0x64,0x3,0x0,0x0,0x17,0x61,
	0x14,0x64,0x3,0x0,0x6,0x40,0x3D,
	0x14,0x64,0x61,0x62,0x64,0x60,0x14,
	0x14,0x64,0x3,0x0,0x6,0x3C,0x54,
	0x14,0x64,0x3,0x0,0x0,0x17,0x62,
	0x14,0x64,0x3,0x0,0xB,0x44,0x49,
	0x14,0x64,0x63,0x63,0x5D,0x40,0x8,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// C
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x1A,0x4B,0x60,0x60,0x4E,0x24,
	0x0,0x1E,0x60,0x28,0x4,0x4,0x22,0x44,
	0x0,0x55,0x30,0x0,0x0,0x0,0x0,0x2,
	0xB,0x64,0xE,0x0,0x0,0x0,0x0,0x0,
	0x12,0x64,0x5,0x0,0x0,0x0,0x0,0x0,
	0xB,0x64,0xE,0x0,0x0,0x0,0x0,0x0,
	0x0,0x56,0x30,0x0,0x0,0x0,0x0,0x2,
	0x0,0x1F,0x60,0x28,0x4,0x4,0x22,0x43,
	0x0,0x0,0x1C,0x4E,0x60,0x61,0x4C,0x23,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// D
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x63,0x62,0x57,0x3A,0x9,0x0,
	0x14,0x64,0x3,0x1,0x11,0x41,0x59,0x9,
	0x14,0x64,0x3,0x0,0x0,0x0,0x47,0x3D,
	0x14,0x64,0x3,0x0,0x0,0x0,0x21,0x5B,
	0x14,0x64,0x3,0x0,0x0,0x0,0x16,0x63,
	0x14,0x64,0x3,0x0,0x0,0x0,0x20,0x5B,
	0x14,0x64,0x3,0x0,0x0,0x0,0x45,0x3B,
	0x14,0x64,0x3,0x1,0x10,0x3F,0x58,0x8,
	0x14,0x64,0x63,0x62,0x59,0x3B,0x9,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// E
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x63,0x63,0x63,0x63,0x44,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x61,0x61,0x61,0x61,0x23,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x63,0x63,0x63,0x63,0x44,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// F
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x63,0x63,0x63,0x63,0x2A,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x61,0x61,0x61,0x61,0x18,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// G
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x18,0x49,0x5F,0x62,0x52,0x31,
	0x0,0x1B,0x60,0x28,0x4,0x3,0x19,0x48,
	0x0,0x54,0x30,0x0,0x0,0x0,0x0,0x0,
	0xB,0x64,0xD,0x0,0x0,0x0,0x0,0x0,
	0x12,0x64,0x4,0x0,0x18,0x61,0x61,0x63,
	0xB,0x64,0xD,0x0,0x0,0x0,0x14,0x64,
	0x0,0x56,0x2F,0x0,0x0,0x0,0x14,0x64,
	0x0,0x20,0x60,0x27,0x4,0x2,0x24,0x64,
	0x0,0x0,0x1D,0x4D,0x60,0x61,0x50,0x2F,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// H
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x0,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x0,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x0,0x0,0x14,0x64,
	0x14,0x64,0x61,0x61,0x61,0x61,0x62,0x64,
	0x14,0x64,0x3,0x0,0x0,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x0,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x0,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x0,0x0,0x14,0x64,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// I
	0x0,0x0,0x0,0x0,0x0,
	0x28,0x63,0x64,0x63,0x19,
	0x0,0x14,0x64,0x3,0x0,
	0x0,0x14,0x64,0x3,0x0,
	0x0,0x14,0x64,0x3,0x0,
	0x0,0x14,0x64,0x3,0x0,
	0x0,0x14,0x64,0x3,0x0,
	0x0,0x14,0x64,0x3,0x0,
	0x0,0x14,0x64,0x3,0x0,
	0x28,0x63,0x64,0x63,0x19,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	// J
	0x0,0x0,0x0,0x0,
	0x7,0x63,0x63,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x16,0x64,
	0x9,0x2,0x35,0x56,
	0x5E,0x62,0x51,0x15,
	0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,
	// K
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x38,0x55,0xA,
	0x14,0x64,0x3,0x0,0x32,0x56,0xB,0x0,
	0x14,0x64,0x3,0x2C,0x57,0xC,0x0,0x0,
	0x14,0x64,0x29,0x58,0xD,0x0,0x0,0x0,
	0x14,0x64,0x60,0x55,0x6,0x0,0x0,0x0,
	0x14,0x64,0xF,0x52,0x49,0x2,0x0,0x0,
	0x14,0x64,0x3,0xC,0x5B,0x3A,0x0,0x0,
	0x14,0x64,0x3,0x0,0x17,0x62,0x29,0x0,
	0x14,0x64,0x3,0x0,0x0,0x26,0x62,0x19,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// L
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0xB,0x8,0x8,0x8,0x2,
	0x14,0x64,0x64,0x64,0x64,0x64,0x19,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// M
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x52,0x0,0x0,0x0,0x3,0x5B,0x64,
	0x14,0x64,0x57,0x1D,0x0,0x0,0x28,0x57,0x64,
	0x14,0x64,0x2A,0x4E,0x0,0x1,0x55,0x29,0x64,
	0x14,0x64,0x5,0x59,0x19,0x20,0x49,0x14,0x64,
	0x14,0x64,0x3,0x2C,0x4A,0x4E,0x19,0x14,0x64,
	0x14,0x64,0x3,0x4,0x5D,0x4E,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x20,0x16,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,0x14,0x64,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// N
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x5C,0x6,0x0,0x0,0x14,0x64,
	0x14,0x64,0x53,0x37,0x0,0x0,0x14,0x64,
	0x14,0x64,0x1B,0x62,0xF,0x0,0x14,0x64,
	0x14,0x64,0x3,0x41,0x47,0x0,0x14,0x64,
	0x14,0x64,0x3,0xB,0x60,0x1C,0x14,0x64,
	0x14,0x64,0x3,0x0,0x31,0x54,0x16,0x64,
	0x14,0x64,0x3,0x0,0x3,0x57,0x40,0x64,
	0x14,0x64,0x3,0x0,0x0,0x21,0x64,0x64,
	0x14,0x64,0x3,0x0,0x0,0x0,0x4B,0x64,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// O
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x1D,0x4D,0x60,0x5F,0x46,0x12,0x0,
	0x0,0x20,0x5F,0x22,0x3,0x6,0x2E,0x5F,0x10,
	0x0,0x56,0x2C,0x0,0x0,0x0,0x0,0x3E,0x42,
	0xB,0x64,0xD,0x0,0x0,0x0,0x0,0x1F,0x5C,
	0x13,0x64,0x4,0x0,0x0,0x0,0x0,0x16,0x64,
	0xB,0x64,0xD,0x0,0x0,0x0,0x0,0x1E,0x5C,
	0x0,0x56,0x2C,0x0,0x0,0x0,0x0,0x3E,0x42,
	0x0,0x21,0x5F,0x23,0x3,0x5,0x2E,0x5F,0x11,
	0x0,0x0,0x1E,0x4E,0x60,0x5F,0x47,0x13,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// P
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x63,0x62,0x59,0x38,0x4,
	0x14,0x64,0x3,0x0,0x10,0x4D,0x40,
	0x14,0x64,0x3,0x0,0x0,0x1A,0x61,
	0x14,0x64,0x3,0x0,0x0,0x1F,0x5D,
	0x14,0x64,0x3,0x1,0x14,0x54,0x33,
	0x14,0x64,0x61,0x60,0x54,0x2D,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// Q
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x1D,0x4E,0x60,0x5E,0x42,0xD,0x0,
	0x0,0x20,0x5F,0x22,0x3,0x6,0x30,0x5B,0xA,
	0x0,0x56,0x2C,0x0,0x0,0x0,0x0,0x41,0x38,
	0xB,0x64,0xC,0x0,0x0,0x0,0x0,0x21,0x55,
	0x13,0x64,0x4,0x0,0x0,0x0,0x0,0x19,0x61,
	0xC,0x64,0xC,0x0,0x0,0x0,0x0,0x21,0x60,
	0x0,0x58,0x2C,0x0,0x0,0x0,0x0,0x41,0x52,
	0x0,0x24,0x5F,0x23,0x3,0x6,0x31,0x64,0x31,
	0x0,0x0,0x22,0x52,0x62,0x64,0x64,0x50,0x4,
	0x0,0x0,0x0,0x0,0x0,0x60,0x3D,0x4,0x0,
	0x0,0x0,0x0,0x0,0x0,0x49,0x42,0x2,0x12,
	0x0,0x0,0x0,0x0,0x0,0xE,0x4E,0x63,0x5D,
	// R
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x63,0x62,0x5F,0x48,0xF,0x0,
	0x14,0x64,0x3,0x0,0x8,0x3D,0x54,0x0,
	0x14,0x64,0x3,0x0,0x0,0x18,0x62,0x0,
	0x14,0x64,0x3,0x0,0xB,0x47,0x40,0x0,
	0x14,0x64,0x61,0x62,0x64,0x34,0x2,0x0,
	0x14,0x64,0x3,0x7,0x58,0x47,0x0,0x0,
	0x14,0x64,0x3,0x0,0x14,0x61,0x31,0x0,
	0x14,0x64,0x3,0x0,0x0,0x26,0x63,0x1B,
	0x14,0x64,0x3,0x0,0x0,0x0,0x3C,0x5C,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// S
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x10,0x4A,0x60,0x60,0x52,0x27,
	0x3,0x5A,0x31,0x5,0x4,0x20,0x33,
	0x12,0x64,0x7,0x0,0x0,0x0,0x0,
	0x4,0x5B,0x45,0x18,0x2,0x0,0x0,
	0x0,0x11,0x44,0x5F,0x61,0x46,0xF,
	0x0,0x0,0x0,0x1,0x14,0x49,0x51,
	0x2,0x0,0x0,0x0,0x0,0x18,0x62,
	0x14,0x45,0x15,0x2,0x7,0x41,0x46,
	0x7,0x3C,0x58,0x62,0x5E,0x3F,0x7,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// T
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x63,0x63,0x63,0x64,0x63,0x63,0x63,0x63,
	0x0,0x0,0x14,0x64,0x2,0x0,0x0,0x0,
	0x0,0x0,0x14,0x64,0x2,0x0,0x0,0x0,
	0x0,0x0,0x14,0x64,0x2,0x0,0x0,0x0,
	0x0,0x0,0x14,0x64,0x2,0x0,0x0,0x0,
	0x0,0x0,0x14,0x64,0x2,0x0,0x0,0x0,
	0x0,0x0,0x14,0x64,0x2,0x0,0x0,0x0,
	0x0,0x0,0x14,0x64,0x2,0x0,0x0,0x0,
	0x0,0x0,0x14,0x64,0x2,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// U
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x0,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x0,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x0,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x0,0x0,0x14,0x64,
	0x14,0x64,0x4,0x0,0x0,0x0,0x15,0x64,
	0xB,0x64,0xD,0x0,0x0,0x0,0x1F,0x5C,
	0x0,0x4E,0x47,0xB,0x0,0x10,0x52,0x3A,
	0x0,0x9,0x40,0x5C,0x62,0x5A,0x37,0x3,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// V
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x57,0x2F,0x0,0x0,0x0,0x0,0x41,0x3F,
	0x33,0x52,0x0,0x0,0x0,0x4,0x60,0x1B,
	0xF,0x64,0x10,0x0,0x0,0x23,0x5A,0x1,
	0x0,0x4F,0x34,0x0,0x0,0x46,0x37,0x0,
	0x0,0x2A,0x57,0x0,0x7,0x62,0x12,0x0,
	0x0,0x8,0x62,0x16,0x28,0x53,0x0,0x0,
	0x0,0x0,0x46,0x39,0x4C,0x2E,0x0,0x0,
	0x0,0x0,0x22,0x5D,0x63,0xB,0x0,0x0,
	0x0,0x0,0x4,0x5F,0x4B,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// W
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x46,0x3A,0x0,0x0,0x0,0x58,0x42,0x0,0x0,0x0,0x50,0x2B,
	0x2B,0x54,0x0,0x0,0xD,0x5F,0x5B,0x0,0x0,0x6,0x63,0x10,
	0x10,0x64,0x9,0x0,0x26,0x3C,0x5B,0x10,0x0,0x1E,0x5A,0x0,
	0x0,0x59,0x22,0x0,0x40,0x23,0x41,0x29,0x0,0x37,0x40,0x0,
	0x0,0x3F,0x3C,0x0,0x59,0xA,0x28,0x43,0x0,0x50,0x25,0x0,
	0x0,0x24,0x55,0xE,0x55,0x0,0xE,0x5B,0x6,0x63,0xB,0x0,
	0x0,0x9,0x64,0x32,0x3C,0x0,0x0,0x58,0x2F,0x55,0x0,0x0,
	0x0,0x0,0x53,0x5E,0x23,0x0,0x0,0x3E,0x5C,0x3A,0x0,0x0,
	0x0,0x0,0x38,0x64,0x9,0x0,0x0,0x24,0x64,0x20,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// X
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x36,0x56,0x4,0x0,0x0,0x15,0x60,0x12,
	0x4,0x56,0x35,0x0,0x2,0x53,0x31,0x0,
	0x0,0x19,0x62,0x12,0x33,0x50,0x2,0x0,
	0x0,0x0,0x3C,0x54,0x5F,0x12,0x0,0x0,
	0x0,0x0,0xC,0x64,0x46,0x0,0x0,0x0,
	0x0,0x0,0x3E,0x4E,0x62,0x17,0x0,0x0,
	0x0,0x1D,0x5D,0x9,0x37,0x54,0x3,0x0,
	0x6,0x59,0x26,0x0,0x4,0x57,0x34,0x0,
	0x3E,0x49,0x0,0x0,0x0,0x1A,0x62,0x13,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// Y
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x60,0x1F,0x0,0x0,0x0,0x2A,0x57,
	0x2E,0x57,0x4,0x0,0xA,0x5F,0x1B,
	0x2,0x52,0x35,0x0,0x43,0x40,0x0,
	0x0,0x17,0x61,0x2C,0x5C,0x8,0x0,
	0x0,0x0,0x3C,0x64,0x24,0x0,0x0,
	0x0,0x0,0x15,0x64,0x3,0x0,0x0,
	0x0,0x0,0x14,0x64,0x3,0x0,0x0,
	0x0,0x0,0x14,0x64,0x3,0x0,0x0,
	0x0,0x0,0x14,0x64,0x3,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	// Z
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x63,0x63,0x63,0x63,0x63,0x64,
	0x0,0x0,0x0,0x0,0x42,0x42,
	0x0,0x0,0x0,0x21,0x5B,0x7,
	0x0,0x0,0x8,0x5C,0x1F,0x0,
	0x0,0x0,0x43,0x40,0x0,0x0,
	0x0,0x23,0x5A,0x6,0x0,0x0,
	0x9,0x5C,0x1D,0x0,0x0,0x0,
	0x45,0x3D,0x0,0x0,0x0,0x0,
	0x64,0x63,0x63,0x63,0x63,0x63,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,

	// [
	0x14,0x64,0x63,0x63,0x16,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x63,0x63,0x16,

	// backslash
	0x33,0x3A,0x0,0x0,0x0,
	0x13,0x5A,0x0,0x0,0x0,
	0x0,0x57,0x16,0x0,0x0,
	0x0,0x37,0x37,0x0,0x0,
	0x0,0x16,0x56,0x0,0x0,
	0x0,0x0,0x5A,0x12,0x0,
	0x0,0x0,0x3A,0x33,0x0,
	0x0,0x0,0x1A,0x53,0x0,
	0x0,0x0,0x1,0x5D,0xF,
	0x0,0x0,0x0,0x3E,0x2F,
	0x0,0x0,0x0,0x1D,0x4F,
	0x0,0x0,0x0,0x2,0x31,
	0x0,0x0,0x0,0x0,0x0,

	// ]
	0x26,0x63,0x63,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x26,0x63,0x63,0x64,

	// ^
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0xA,0x5D,0x2F,0x0,0x0,0x0,
	0x0,0x0,0x48,0x37,0x5B,0x13,0x0,0x0,
	0x0,0x2A,0x4E,0x1,0x23,0x53,0x3,0x0,
	0xF,0x5C,0xF,0x0,0x0,0x43,0x38,0x0,
	0x4F,0x2B,0x0,0x0,0x0,0x7,0x5A,0x1A,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,

	// _
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x63,0x63,0x63,0x63,0x63,0x63,0x63,0x14,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,

	// `
	0x49,0x38,
	0xA,0x59,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,

	// a
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x31,0x5D,0x62,0x56,0x1D,
	0x0,0x16,0xA,0x1,0x2E,0x59,
	0x0,0x1,0x19,0x2D,0x3E,0x64,
	0x0,0x49,0x55,0x32,0x33,0x64,
	0xF,0x64,0xC,0x0,0x14,0x64,
	0xA,0x64,0x1B,0x5,0x39,0x64,
	0x0,0x30,0x60,0x59,0x38,0x64,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,

	// b
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x33,0x59,0x61,0x46,0x7,
	0x14,0x64,0x2F,0x7,0x6,0x49,0x3E,
	0x14,0x64,0x3,0x0,0x0,0x1E,0x5D,
	0x14,0x64,0x3,0x0,0x0,0x16,0x64,
	0x14,0x64,0x3,0x0,0x0,0x22,0x57,
	0x14,0x64,0x15,0x0,0xF,0x53,0x2E,
	0x14,0x64,0x4F,0x61,0x5D,0x34,0x1,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,

	// c
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x5,0x3D,0x5D,0x61,0x4E,0x10,
	0x0,0x45,0x4B,0xA,0x4,0x24,0x16,
	0x9,0x64,0x12,0x0,0x0,0x0,0x0,
	0x12,0x64,0x4,0x0,0x0,0x0,0x0,
	0x9,0x64,0x12,0x0,0x0,0x0,0x0,
	0x0,0x47,0x49,0x9,0x3,0x22,0x16,
	0x0,0x7,0x3F,0x5D,0x61,0x4C,0x10,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,

	// d
	0x0,0x0,0x0,0x0,0x0,0x14,0x64,
	0x0,0x0,0x0,0x0,0x0,0x14,0x64,
	0x0,0x0,0x0,0x0,0x0,0x14,0x64,
	0x0,0x5,0x3D,0x5F,0x5F,0x4E,0x64,
	0x0,0x41,0x49,0x9,0x2,0x24,0x64,
	0x7,0x64,0x12,0x0,0x0,0x14,0x64,
	0x12,0x64,0x4,0x0,0x0,0x14,0x64,
	0xB,0x64,0xD,0x0,0x0,0x14,0x64,
	0x0,0x50,0x3C,0x4,0x9,0x3B,0x64,
	0x0,0xF,0x4D,0x62,0x57,0x3B,0x64,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,

	// e
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x5,0x3E,0x5E,0x5F,0x3B,0x2,
	0x0,0x43,0x45,0x6,0x8,0x4F,0x2C,
	0x8,0x64,0xD,0x0,0x0,0x28,0x49,
	0x12,0x64,0x61,0x61,0x61,0x62,0x4E,
	0x9,0x64,0xA,0x0,0x0,0x0,0x0,
	0x0,0x47,0x42,0x9,0x0,0x11,0x2B,
	0x0,0x6,0x3C,0x5C,0x62,0x56,0x2F,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,

	// f
	0x0,0x24,0x5B,0x61,0x1B,
	0x5,0x60,0x22,0x0,0x0,
	0x12,0x64,0x4,0x0,0x0,
	0x63,0x64,0x63,0x55,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,

	// g
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x5,0x3E,0x5F,0x60,0x52,0x64,
	0x0,0x40,0x49,0x9,0x2,0x27,0x64,
	0x6,0x63,0x12,0x0,0x0,0x14,0x64,
	0x12,0x64,0x4,0x0,0x0,0x14,0x64,
	0xC,0x64,0xD,0x0,0x0,0x14,0x64,
	0x0,0x52,0x3C,0x4,0x9,0x38,0x64,
	0x0,0x10,0x4E,0x62,0x59,0x3E,0x64,
	0x0,0x0,0x0,0x0,0x0,0x1A,0x5B,
	0x0,0x18,0x14,0x1,0x9,0x47,0x3B,
	0x0,0x2A,0x5C,0x63,0x5C,0x3C,0x5,

	// h
	0x14,0x64,0x3,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,
	0x14,0x64,0x33,0x5C,0x5B,0x1E,
	0x14,0x64,0x2E,0x3,0x30,0x57,
	0x14,0x64,0x3,0x0,0x17,0x64,
	0x14,0x64,0x3,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x14,0x64,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,

	// i
	0x0,0x0,
	0x14,0x63,
	0x0,0x0,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,

	// j
	0x0,0x0,0x0,0x0,
	0x0,0x0,0x14,0x63,
	0x0,0x0,0x0,0x0,
	0x0,0x25,0x63,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x14,0x64,
	0x0,0x0,0x16,0x64,
	0x0,0x0,0x31,0x57,
	0x13,0x62,0x57,0x1A,

	// k
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x40,0x4D,0x5,
	0x14,0x64,0x3,0x3B,0x4D,0x5,0x0,
	0x14,0x64,0x39,0x4E,0x5,0x0,0x0,
	0x14,0x64,0x57,0x53,0x5,0x0,0x0,
	0x14,0x64,0x6,0x4F,0x44,0x0,0x0,
	0x14,0x64,0x3,0xB,0x5C,0x31,0x0,
	0x14,0x64,0x3,0x0,0x1A,0x62,0x1F,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,

	// l
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x0,0x0,
	0x0,0x0,
	0x0,0x0,

	// m
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x35,0x5D,0x5B,0x23,0x31,0x5D,0x5B,0x1F,
	0x14,0x64,0x2E,0x3,0x2E,0x64,0x2D,0x3,0x2D,0x58,
	0x14,0x64,0x3,0x0,0x16,0x64,0x2,0x0,0x16,0x64,
	0x14,0x64,0x3,0x0,0x14,0x64,0x2,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x14,0x64,0x2,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x14,0x64,0x2,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x14,0x64,0x2,0x0,0x14,0x64,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,

	// n
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x34,0x5C,0x5B,0x1E,
	0x14,0x64,0x2E,0x3,0x30,0x57,
	0x14,0x64,0x3,0x0,0x17,0x64,
	0x14,0x64,0x3,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x14,0x64,
	0x14,0x64,0x3,0x0,0x14,0x64,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,

	// o
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x8,0x43,0x60,0x5D,0x39,0x2,
	0x0,0x49,0x41,0x5,0xA,0x4E,0x36,
	0x9,0x64,0xE,0x0,0x0,0x20,0x5B,
	0x13,0x64,0x4,0x0,0x0,0x16,0x64,
	0x9,0x64,0xF,0x0,0x0,0x20,0x5B,
	0x0,0x49,0x43,0x5,0xA,0x4F,0x37,
	0x0,0x9,0x44,0x60,0x5E,0x3A,0x3,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,

	// p
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x33,0x58,0x61,0x47,0x7,
	0x14,0x64,0x30,0x7,0x6,0x4A,0x3F,
	0x14,0x64,0x3,0x0,0x0,0x1E,0x5D,
	0x14,0x64,0x3,0x0,0x0,0x16,0x63,
	0x14,0x64,0x3,0x0,0x0,0x23,0x57,
	0x14,0x64,0x15,0x0,0xF,0x55,0x2E,
	0x14,0x64,0x4C,0x61,0x5C,0x33,0x1,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,0x0,0x0,

	// q
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x5,0x3E,0x5F,0x60,0x52,0x64,
	0x0,0x41,0x49,0x9,0x2,0x26,0x64,
	0x7,0x63,0x11,0x0,0x0,0x14,0x64,
	0x12,0x64,0x4,0x0,0x0,0x14,0x64,
	0xB,0x64,0xE,0x0,0x0,0x14,0x64,
	0x0,0x4F,0x3E,0x4,0x9,0x3A,0x64,
	0x0,0xE,0x4C,0x62,0x56,0x39,0x64,
	0x0,0x0,0x0,0x0,0x0,0x14,0x64,
	0x0,0x0,0x0,0x0,0x0,0x14,0x64,
	0x0,0x0,0x0,0x0,0x0,0x14,0x64,

	// r
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x32,0x59,0x3A,
	0x14,0x64,0x2D,0x4,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,

	// s
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x25,0x57,0x62,0x59,0x31,
	0xB,0x63,0x1C,0x1,0x10,0x27,
	0xB,0x64,0x28,0x5,0x0,0x0,
	0x0,0x26,0x54,0x63,0x51,0x1D,
	0x0,0x0,0x0,0x7,0x35,0x5D,
	0x12,0x2B,0x9,0x1,0x2A,0x59,
	0xB,0x47,0x5E,0x62,0x4F,0x16,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,

	// t
	0x0,0x0,0x0,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x63,0x64,0x63,0x63,0x16,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0x14,0x64,0x3,0x0,0x0,
	0xB,0x64,0x17,0x6,0x4,
	0x0,0x36,0x60,0x5F,0x12,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,

	// u
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x64,0x3,0x0,0x14,0x64,
	0x64,0x3,0x0,0x14,0x64,
	0x64,0x3,0x0,0x14,0x64,
	0x64,0x3,0x0,0x14,0x64,
	0x64,0x4,0x0,0x14,0x64,
	0x62,0x1E,0x5,0x3C,0x64,
	0x2D,0x5F,0x59,0x39,0x64,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,

	// v
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x4E,0x33,0x0,0x0,0x4,0x5F,0x19,
	0x28,0x56,0x0,0x0,0x23,0x56,0x0,
	0x6,0x60,0x16,0x0,0x47,0x30,0x0,
	0x0,0x40,0x3A,0x8,0x61,0xB,0x0,
	0x0,0x1A,0x5C,0x2C,0x48,0x0,0x0,
	0x0,0x0,0x58,0x5E,0x22,0x0,0x0,
	0x0,0x0,0x33,0x5D,0x3,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,

	// w
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x45,0x37,0x0,0x0,0x4E,0x32,0x0,0x0,0x55,0x21,
	0x2B,0x4E,0x0,0xA,0x5F,0x52,0x0,0x7,0x63,0x7,
	0x11,0x62,0x4,0x29,0x37,0x59,0xE,0x1D,0x51,0x0,
	0x0,0x5B,0x18,0x48,0x16,0x39,0x2E,0x33,0x37,0x0,
	0x0,0x41,0x35,0x57,0x0,0x18,0x4E,0x49,0x1E,0x0,
	0x0,0x27,0x5F,0x3B,0x0,0x1,0x5B,0x5F,0x5,0x0,
	0x0,0xD,0x64,0x1B,0x0,0x0,0x3C,0x4E,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,

	// x
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x38,0x55,0x3,0x0,0x20,0x5C,
	0x3,0x54,0x36,0x7,0x5B,0x1F,
	0x0,0x14,0x61,0x4C,0x3C,0x0,
	0x0,0x0,0x41,0x63,0xA,0x0,
	0x0,0x12,0x5D,0x4E,0x40,0x0,
	0x4,0x54,0x2A,0xC,0x5F,0x21,
	0x3A,0x4B,0x0,0x0,0x2A,0x5D,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,

	// y
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x4F,0x33,0x0,0x0,0x4,0x5F,0x19,
	0x2A,0x56,0x0,0x0,0x23,0x56,0x0,
	0x7,0x62,0x16,0x0,0x47,0x30,0x0,
	0x0,0x43,0x3A,0x8,0x61,0xB,0x0,
	0x0,0x1E,0x5C,0x2C,0x48,0x0,0x0,
	0x0,0x2,0x5B,0x5E,0x22,0x0,0x0,
	0x0,0x0,0x38,0x5D,0x3,0x0,0x0,
	0x0,0x0,0x3E,0x3A,0x0,0x0,0x0,
	0x0,0x7,0x60,0x14,0x0,0x0,0x0,
	0x0,0x2D,0x52,0x0,0x0,0x0,0x0,
	// z
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x55,0x63,0x63,0x63,0x63,
	0x0,0x0,0x1,0x4B,0x36,
	0x0,0x0,0x2E,0x52,0x2,
	0x0,0x12,0x5E,0x11,0x0,
	0x3,0x53,0x2C,0x0,0x0,
	0x38,0x49,0x0,0x0,0x0,
	0x64,0x63,0x63,0x63,0x63,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,
	// {
	0x0,0x0,0x0,0x1B,0x56,0x63,
	0x0,0x0,0x2,0x5C,0x2D,0x1,
	0x0,0x0,0x10,0x64,0x7,0x0,
	0x0,0x0,0x14,0x64,0x3,0x0,
	0x0,0x0,0x16,0x64,0x2,0x0,
	0x0,0x0,0x23,0x59,0x0,0x0,
	0x0,0xB,0x50,0x25,0x0,0x0,
	0x1D,0x64,0x38,0x0,0x0,0x0,
	0x0,0x7,0x46,0x3D,0x0,0x0,
	0x0,0x0,0x1A,0x63,0x2,0x0,
	0x0,0x0,0x14,0x64,0x4,0x0,
	0x0,0x0,0xB,0x64,0x20,0x0,
	0x0,0x0,0x0,0x2C,0x5B,0x63,
	// |
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	0x14,0x64,
	// }
	0x16,0x62,0x50,0x10,0x0,0x0,0x0,
	0x0,0x2,0x3C,0x4C,0x0,0x0,0x0,
	0x0,0x0,0x18,0x62,0x0,0x0,0x0,
	0x0,0x0,0x14,0x64,0x3,0x0,0x0,
	0x0,0x0,0x13,0x64,0x4,0x0,0x0,
	0x0,0x0,0x7,0x62,0x11,0x0,0x0,
	0x0,0x0,0x0,0x36,0x44,0x6,0x0,
	0x0,0x0,0x0,0x2,0x48,0x64,0xB,
	0x0,0x0,0x1,0x4D,0x38,0x4,0x0,
	0x0,0x0,0x12,0x64,0x8,0x0,0x0,
	0x0,0x0,0x15,0x64,0x3,0x0,0x0,
	0x0,0x1,0x30,0x5D,0x0,0x0,0x0,
	0x16,0x63,0x57,0x1F,0x0,0x0,0x0,
	// ~
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x14,0x56,0x5D,0x2D,0x0,0x0,0x39,0x2D,
	0x4C,0x25,0xC,0x56,0x2F,0x6,0x54,0x19,
	0x5F,0x7,0x0,0xC,0x4C,0x60,0x3A,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
};
//*******************************************************************************
const unsigned char font2_sizes[94] PROGMEM = {
	0x03, 0x05, 0x09, 0x08, 0x0F, 0x0A, 0x03, 0x05, 0x06, 0x07, 0x08, 0x04, 0x04, 0x03, 0x07,
	0x08, 0x06, 0x07, 0x08, 0x08, 0x08, 0x08, 0x07, 0x07, 0x08, 0x03, 0x04, 0x08, 0x08, 0x08,
	0x07, 0x0A, 0x09, 0x08, 0x08, 0x09, 0x07, 0x07, 0x09, 0x08, 0x05, 0x06, 0x08, 0x07, 0x0A,
	0x08, 0x09, 0x08, 0x09, 0x09, 0x08, 0x08, 0x08, 0x09, 0x0D, 0x09, 0x08, 0x08, 0x05, 0x06,
	0x05, 0x09, 0x08, 0x03, 0x07, 0x07, 0x07, 0x07, 0x07, 0x06, 0x07, 0x07, 0x03, 0x05, 0x07,
	0x02, 0x0B, 0x07, 0x08, 0x07, 0x07, 0x05, 0x06, 0x05, 0x07, 0x08, 0x0C, 0x08, 0x08, 0x06,
	0x08, 0x03, 0x08, 0x0A, 
};
//*******************************************************************************
const unsigned char font2_data[9177] PROGMEM = {
	0x0,0x0,0x0,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0x0,0x0,0x0,0x84,0x84,0x25,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0xFF,0xD4,0x78,0xFF,0x80,0xFF,0xBC,0x60,0xFF,0x68,0xF4,0xA4,0x48,0xFF,0x50,0xDC,0x8C,0x30,0xFF,0x38,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xA1,0xC3,0x0,0xC1,0x9F,0x0,0x0,0x0,0x0,0xE2,0x81,0x9,0xF9,0x5D,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0x84,0xB6,0xFB,0x84,0xC3,0xEA,0x84,0x84,0x0,0x0,0x96,0xC7,0x0,0xB4,0xA5,0x0,0x0,0x84,0x84,0xE3,0xCD,0x84,0xF2,0xBD,0x84,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x4D,0xFE,0x17,0x6D,0xED,0x1,0x0,0x0,0x0,0x8F,0xD2,0x0,0xAF,0xAD,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1C,0xF0,0x0,0x0,0x0,0x0,0x0,0x38,0x83,0xF8,0x78,0x4F,0xA,0x0,0x9C,0xFF,0xFF,0xFF,0xFF,0xFF,0x50,0x13,0xFF,0xFF,0x43,0xF0,0xB,0x47,0x2B,0x3,0xE0,0xFF,0xE2,0xF9,0x81,0x39,0x0,0x0,0x20,0x9A,0xE3,0xFF,0xFF,0xFF,0x96,0x4,0xB,0x0,0x1C,0xF1,0x7A,0xFF,0xF8,0x1C,0xF3,0xB2,0x98,0xF8,0xC5,0xFF,0xC0,0xE,0xB0,0xE2,0xFB,0xFF,0xF1,0xA6,0x17,0x0,0x0,0x0,0x1C,0xF0,0x0,0x0,0x0,0x0,0x0,0x0,0x1C,0xF0,0x0,0x0,0x0,0x0,0x0,0x0,0x1C,0xF0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1A,0xB2,0xF4,0xF6,0xB6,0x1C,0x0,0x0,0x82,0xFF,0x8E,0x0,0x0,0x0,0x0,0xB5,0xFF,0xC6,0xC6,0xFF,0xB7,0x0,0x19,0xF4,0xF0,0x13,0x0,0x0,0x0,0x0,0xF5,0xFF,0x4F,0x4F,0xFF,0xF6,0x0,0x9A,0xFF,0x79,0x0,0x0,0x0,0x0,0x0,0xF6,0xFF,0x4D,0x4F,0xFF,0xF4,0x29,0xFC,0xE4,0x53,0xD8,0xFB,0xDB,0x4F,0x0,0xB6,0xFF,0xC6,0xC7,0xFF,0xB3,0xB2,0xFF,0x71,0xF3,0xFF,0xB2,0xFF,0xF5,0xF,0x1C,0xB5,0xF5,0xF5,0xB4,0x58,0xFF,0xD5,0x41,0xFF,0xFF,0xD,0xFF,0xFF,0x3E,0x0,0x0,0x0,0x0,0x0,0xC9,0xFF,0x4E,0x3E,0xFF,0xFF,0x3,0xFF,0xFF,0x3D,0x0,0x0,0x0,0x0,0x56,0xFF,0xC3,0x0,0xF,0xF5,0xFF,0x51,0xFF,0xF4,0xE,0x0,0x0,0x0,0x5,0xDC,0xFF,0x39,0x0,0x0,0x4F,0xDB,0xFC,0xDA,0x4C,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60,0xD9,0xFB,0xE5,0x79,0x0,0x0,0x0,0x0,0x25,0xFE,0xFF,0xAA,0xFF,0xFF,0x31,0x0,0x0,0x0,0x3F,0xFF,0xFF,0x14,0xFF,0xFF,0x30,0x0,0x0,0x0,0x7,0xDB,0xFF,0xCB,0xFF,0x98,0x0,0x0,0x0,0x0,0x1A,0xC2,0xF8,0xFF,0xC6,0x16,0x48,0xFF,0xFE,0x0,0xC1,0xFF,0x60,0x92,0xFF,0xEE,0x9F,0xFF,0xCB,0x0,0xF9,0xFF,0x68,0x0,0x74,0xFE,0xFF,0xF6,0x34,0x0,0xB4,0xFF,0xF5,0x95,0x96,0xF4,0xFF,0xFF,0x87,0x0,0xF,0x93,0xE3,0xFC,0xEE,0xB4,0x6C,0xFF,0xFF,0x97,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x33,0xFF,0xC7,0x1A,0xFF,0xAE,0x3,0xFD,0x95,0x0,0xE8,0x7C,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0xC,0xC8,0xFF,0x97,0x0,0xB1,0xFF,0xAF,0x1,0x4C,0xFF,0xF5,0x17,0x0,0xB4,0xFF,0x9E,0x0,0x0,0xEC,0xFF,0x5F,0x0,0x0,0xFC,0xFF,0x4C,0x0,0x0,0xEA,0xFF,0x5F,0x0,0x0,0xB2,0xFF,0x9D,0x0,0x0,0x4D,0xFF,0xF4,0x16,0x0,0x0,0xAF,0xFF,0xAE,0x1,0x0,0xC,0xC8,0xFF,0x97,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x54,0xFB,0xED,0x2E,0x0,0x0,0x0,0x67,0xFF,0xE3,0x12,0x0,0x0,0x0,0xC3,0xFF,0x92,0x0,0x0,0x0,0x56,0xFF,0xF2,0x6,0x0,0x0,0x18,0xFF,0xFF,0x32,0x0,0x0,0x4,0xFF,0xFF,0x44,0x0,0x0,0x17,0xFF,0xFF,0x30,0x0,0x0,0x55,0xFF,0xF1,0x5,0x0,0x0,0xC3,0xFF,0x91,0x0,0x0,0x67,0xFF,0xE4,0x13,0x0,0x53,0xFB,0xEE,0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x3,0x2C,0xFC,0x0,0x9,0x0,0x7A,0xC8,0x56,0xFC,0x43,0xDE,0x53,0x5,0x74,0xEF,0xFF,0xE3,0x5E,0x1,0x7,0x76,0xF0,0xFF,0xE2,0x5D,0x1,0x7D,0xC9,0x58,0xFC,0x3B,0xDA,0x52,0x6,0x3,0x2C,0xFC,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x84,0x84,0x84,0xFF,0xFF,0xA6,0x84,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xE7,0xFF,0x53,0x28,0xFF,0xDE,0x2,0x68,0xFF,0x6F,0x0,0xA8,0xF0,0xD,0x0,0xE7,0x8C,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x84,0x84,0x84,0x84,0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x28,0x28,0xB,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xAA,0xFF,0x2A,0x0,0x0,0x0,0x9,0xF4,0xD6,0x0,0x0,0x0,0x0,0x51,0xFF,0x83,0x0,0x0,0x0,0x0,0xA4,0xFF,0x2F,0x0,0x0,0x0,0x6,0xF1,0xDB,0x0,0x0,0x0,0x0,0x4B,0xFF,0x88,0x0,0x0,0x0,0x0,0x9F,0xFF,0x35,0x0,0x0,0x0,0x4,0xED,0xE0,0x0,0x0,0x0,0x0,0x46,0xFF,0x8E,0x0,0x0,0x0,0x0,0x99,0xFF,0x3A,0x0,0x0,0x0,0x3,0xE9,0xE5,0x1,0x0,0x0,0x0,0x15,0x80,0x54,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6F,0xDB,0xFA,0xE9,0x98,0xB,0x0,0x61,0xFF,0xF3,0x90,0xD8,0xFF,0xA5,0x0,0xC8,0xFF,0x81,0x0,0x39,0xFF,0xFB,0xE,0xF2,0xFF,0x53,0x0,0xB,0xFF,0xFF,0x37,0xFD,0xFF,0x49,0x0,0x2,0xFF,0xFF,0x44,0xF1,0xFF,0x53,0x0,0xC,0xFF,0xFF,0x38,0xC6,0xFF,0x81,0x0,0x3C,0xFF,0xFB,0xF,0x5E,0xFF,0xF2,0x8F,0xD9,0xFF,0xA7,0x0,0x0,0x6F,0xDC,0xFA,0xEA,0x9B,0xC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x5,0x31,0xEC,0xFF,0x48,0x0,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x84,0x84,0xFF,0xFF,0x48,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x94,0x94,0xFF,0xFF,0xB2,0x94,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xA6,0xDD,0xFA,0xF4,0xBF,0x34,0x0,0xFF,0xBD,0x8A,0xCE,0xFF,0xEE,0xE,0x3A,0x0,0x0,0x15,0xFF,0xFF,0x40,0x0,0x0,0x0,0x23,0xFF,0xFF,0x29,0x0,0x0,0x0,0xAD,0xFF,0xC3,0x0,0x0,0x0,0x88,0xFF,0xE8,0x21,0x0,0x3,0x96,0xFF,0xE0,0x29,0x0,0x0,0xB6,0xFF,0xFD,0x99,0x84,0x84,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1F,0xB1,0xE3,0xFB,0xF5,0xC9,0x53,0x0,0x3C,0xF0,0xA5,0x87,0xBA,0xFF,0xFD,0x24,0xF,0xE,0x0,0x0,0xC,0xFF,0xFF,0x37,0x0,0x0,0x3F,0x89,0xC7,0xFD,0x9A,0x1,0x0,0x0,0x7C,0xFF,0xFF,0xE2,0x62,0x0,0x0,0x0,0x0,0x1,0x43,0xFF,0xFE,0x27,0x26,0x8,0x0,0x0,0x15,0xFF,0xFF,0x3C,0x80,0xE9,0x9C,0x89,0xD3,0xFF,0xDF,0x7,0x4A,0xC8,0xF0,0xFD,0xED,0xAA,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x71,0xFF,0xFF,0x48,0x0,0x0,0x0,0x31,0xF9,0xFF,0xFF,0x48,0x0,0x0,0xB,0xD8,0xD2,0xFF,0xFF,0x48,0x0,0x0,0x9C,0xF6,0x2B,0xFF,0xFF,0x48,0x0,0x55,0xFF,0x69,0x0,0xFF,0xFF,0x48,0x0,0xEF,0xF0,0x84,0x84,0xFF,0xFF,0xA6,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x8,0x0,0xFF,0xFF,0xA6,0x84,0x84,0x84,0x4,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xF9,0xC9,0x3D,0x0,0x0,0xB7,0x8D,0x8E,0xD8,0xFF,0xF0,0xE,0x0,0x0,0x0,0x0,0x16,0xFF,0xFF,0x40,0x2B,0x9,0x0,0x0,0x1F,0xFF,0xFF,0x2D,0x80,0xEA,0x99,0x8D,0xDC,0xFF,0xC3,0x0,0x4E,0xCD,0xF3,0xFD,0xE7,0x97,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xF,0x84,0xD6,0xF7,0xF7,0x75,0x0,0xF,0xD7,0xFF,0xCC,0x8C,0x93,0x61,0x0,0x8B,0xFF,0xB9,0x1,0x0,0x0,0x0,0x0,0xDA,0xFF,0xC2,0xE4,0xFE,0xD3,0x40,0x0,0xF8,0xFF,0xB7,0x84,0xCB,0xFF,0xF0,0xE,0xF6,0xFF,0x4C,0x0,0x12,0xFF,0xFF,0x3F,0xCE,0xFF,0x7D,0x0,0x17,0xFF,0xFF,0x31,0x5E,0xFF,0xF5,0x95,0xD0,0xFF,0xC9,0x1,0x0,0x64,0xD6,0xFB,0xEC,0xA1,0x14,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x84,0x84,0x84,0x84,0xCF,0xFF,0xF5,0x0,0x0,0x0,0x16,0xF1,0xFF,0x83,0x0,0x0,0x0,0x99,0xFF,0xE9,0xD,0x0,0x0,0x2D,0xFC,0xFF,0x6A,0x0,0x0,0x0,0xBB,0xFF,0xD9,0x4,0x0,0x0,0x4D,0xFF,0xFF,0x52,0x0,0x0,0x5,0xD9,0xFF,0xC5,0x0,0x0,0x0,0x6F,0xFF,0xFF,0x3A,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x13,0x95,0xE3,0xFB,0xF0,0xBC,0x40,0xC1,0xFF,0xDB,0x8B,0xC2,0xFF,0xF8,0xF5,0xFF,0x60,0x0,0xC,0xFF,0xFF,0x95,0xFF,0xF8,0xA5,0x93,0xFF,0x99,0x9,0xC3,0xFD,0xFF,0xFF,0xEC,0x4A,0xAF,0xFF,0x6C,0x35,0xAC,0xFF,0xF8,0xF8,0xFF,0x5D,0x0,0xB,0xFF,0xFF,0xBF,0xFF,0xEB,0x90,0xBD,0xFF,0xE9,0x14,0x99,0xE4,0xFC,0xEE,0xAE,0x28,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x76,0xDB,0xFA,0xE6,0x92,0xB,0x0,0x82,0xFF,0xEA,0x8C,0xDA,0xFF,0xAA,0x0,0xEA,0xFF,0x60,0x0,0x31,0xFF,0xFF,0x17,0xF6,0xFF,0x5D,0x0,0x3,0xFF,0xFF,0x3E,0xB2,0xFF,0xEF,0x9A,0xA5,0xFF,0xFF,0x3F,0x12,0xA3,0xE4,0xDC,0xA1,0xFF,0xFF,0x1B,0x0,0x0,0x0,0x0,0x8E,0xFF,0xC9,0x0,0x3D,0xBC,0xA7,0xD4,0xFF,0xF4,0x35,0x0,0x3A,0xF2,0xFB,0xE6,0xA7,0x29,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0x28,0x28,0xB,0x0,0x0,0x0,0x28,0x28,0xB,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0xFF,0xFF,0x48,0x0,0x28,0x28,0xB,0x0,0x0,0x0,0x0,0x0,0xD0,0xFF,0x72,0x12,0xFE,0xF0,0xD,0x50,0xFF,0x8B,0x0,0x90,0xFB,0x1D,0x0,0xD0,0xA5,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x45,0xAC,0x0,0x0,0x0,0x16,0x77,0xDC,0xFF,0xF2,0x1,0x42,0xA9,0xFA,0xFF,0xCA,0x64,0xC,0xDA,0xFF,0xF0,0x95,0x2F,0x0,0x0,0x0,0xE1,0xFF,0xEB,0x8C,0x27,0x0,0x0,0x0,0x2,0x4C,0xB3,0xFC,0xFF,0xC1,0x5B,0x8,0x0,0x0,0x0,0x1D,0x82,0xE5,0xFF,0xEE,0x0,0x0,0x0,0x0,0x0,0x4,0x51,0xB8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xAC,0x44,0x1,0x0,0x0,0x0,0x0,0x0,0xF2,0xFF,0xDC,0x76,0x16,0x0,0x0,0x0,0xC,0x65,0xCA,0xFF,0xF9,0xA8,0x41,0x1,0x0,0x0,0x0,0x2F,0x96,0xF0,0xFF,0xDA,0x0,0x0,0x0,0x28,0x8C,0xEB,0xFF,0xE1,0x8,0x5C,0xC1,0xFF,0xFC,0xB3,0x4B,0x2,0xEE,0xFF,0xE5,0x82,0x1D,0x0,0x0,0x0,0xB8,0x51,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4D,0xC9,0xF0,0xFC,0xEA,0xA4,0x1A,0x80,0xD4,0x93,0x92,0xE9,0xFF,0xC6,0x11,0x0,0x0,0x0,0x58,0xFF,0xF8,0x0,0x0,0x0,0x4,0xA6,0xFF,0xB4,0x0,0x0,0x85,0xDD,0xFF,0xB3,0x14,0x0,0x0,0xFF,0xFF,0x5E,0x0,0x0,0x0,0x0,0xA8,0xA8,0x2F,0x0,0x0,0x0,0x0,0x84,0x84,0x25,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x51,0xC0,0xF3,0xF3,0xC1,0x58,0x0,0x0,0x0,0x8F,0xFF,0xCE,0x8F,0x8E,0xC4,0xFF,0x9A,0x0,0x58,0xFC,0x65,0x9B,0xF5,0xC4,0xFC,0x4A,0xF8,0x58,0xD1,0x83,0x79,0xFF,0xC2,0xA7,0xFC,0x0,0x88,0xC0,0xFF,0x1D,0xC8,0xFF,0x1E,0x2C,0xFC,0x0,0x3D,0xEF,0xFF,0x2,0xD0,0xFF,0x5,0x2C,0xFC,0x0,0x35,0xF3,0xFF,0x19,0xA0,0xFF,0x38,0x44,0xFC,0x0,0x76,0xCD,0xDA,0x71,0x21,0xDF,0xFD,0xDE,0xFF,0xF0,0xFB,0x85,0x6B,0xF4,0x3E,0x3,0x1B,0x1,0x1F,0x20,0x20,0x9,0x2,0xAF,0xFE,0xB8,0x89,0x94,0xC8,0x0,0x0,0x0,0x0,0x3,0x6E,0xD1,0xF8,0xF6,0xCB,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xE,0xF7,0xFF,0xE9,0x3,0x0,0x0,0x0,0x0,0x60,0xFF,0xFF,0xFF,0x47,0x0,0x0,0x0,0x0,0xBB,0xFF,0xE9,0xFF,0xA2,0x0,0x0,0x0,0x18,0xFC,0xFC,0x54,0xFF,0xF3,0x9,0x0,0x0,0x70,0xFF,0xBE,0x1,0xE4,0xFF,0x57,0x0,0x0,0xCB,0xFF,0xD3,0xA4,0xE1,0xFF,0xB2,0x0,0x25,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFA,0x12,0x80,0xFF,0xCA,0x0,0x0,0x3,0xEE,0xFF,0x67,0xDA,0xFF,0x7E,0x0,0x0,0x0,0xA6,0xFF,0xC2,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFE,0xF0,0xB0,0x18,0x0,0xFF,0xFF,0xA6,0x8A,0xEE,0xFF,0x98,0x0,0xFF,0xFF,0x48,0x0,0x9A,0xFF,0xA0,0x0,0xFF,0xFF,0xA6,0x8C,0xF0,0xE5,0x2C,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0xF2,0x78,0x0,0xFF,0xFF,0x48,0x0,0x4A,0xFF,0xFF,0x2A,0xFF,0xFF,0x48,0x0,0x10,0xFF,0xFF,0x3E,0xFF,0xFF,0xA6,0x85,0xCA,0xFF,0xE4,0x9,0xFF,0xFF,0xFF,0xFF,0xF1,0xB4,0x27,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x12,0x8D,0xDC,0xFA,0xF5,0xD1,0x83,0x15,0xDC,0xFF,0xE4,0x92,0x94,0xE3,0xFF,0x96,0xFF,0xDB,0x11,0x0,0x0,0x6,0x81,0xE4,0xFF,0x6C,0x0,0x0,0x0,0x0,0x0,0xFB,0xFF,0x4D,0x0,0x0,0x0,0x0,0x0,0xE6,0xFF,0x6A,0x0,0x0,0x0,0x0,0x0,0x9D,0xFF,0xD9,0xF,0x0,0x0,0x6,0x81,0x1B,0xE4,0xFF,0xE4,0x92,0x92,0xDF,0xFF,0x0,0x17,0x94,0xE0,0xFB,0xF8,0xCD,0x7B,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xF9,0xE2,0xA3,0x27,0x0,0x0,0xFF,0xFF,0xA6,0x86,0xBE,0xFF,0xF2,0x37,0x0,0xFF,0xFF,0x48,0x0,0x0,0x98,0xFF,0xD8,0x1,0xFF,0xFF,0x48,0x0,0x0,0x23,0xFF,0xFF,0x2C,0xFF,0xFF,0x48,0x0,0x0,0x5,0xFF,0xFF,0x44,0xFF,0xFF,0x48,0x0,0x0,0x20,0xFF,0xFF,0x2A,0xFF,0xFF,0x48,0x0,0x0,0x92,0xFF,0xD1,0x0,0xFF,0xFF,0xA6,0x85,0xB8,0xFF,0xF0,0x30,0x0,0xFF,0xFF,0xFF,0xFA,0xE3,0xA1,0x24,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0xFF,0xFF,0xA6,0x84,0x84,0x84,0x42,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0xA6,0x84,0x84,0x84,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0xA6,0x84,0x84,0x84,0x42,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0xFF,0xFF,0xA6,0x84,0x84,0x84,0x42,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0xA6,0x84,0x84,0x84,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xE,0x87,0xD8,0xF8,0xF8,0xDA,0x93,0x18,0x12,0xD7,0xFF,0xE7,0x97,0x8E,0xCD,0xFF,0x48,0x93,0xFF,0xD8,0x10,0x0,0x0,0x0,0x52,0x33,0xE4,0xFF,0x69,0x0,0x0,0x0,0x0,0x0,0x0,0xFB,0xFF,0x4C,0x0,0xD8,0xFF,0xFF,0xFF,0x48,0xE6,0xFF,0x6C,0x0,0x6F,0x84,0xFF,0xFF,0x48,0x9C,0xFF,0xDB,0x15,0x0,0x0,0xFF,0xFF,0x48,0x1A,0xE1,0xFF,0xED,0x9E,0x85,0xFF,0xFF,0x48,0x0,0x14,0x8F,0xDD,0xFA,0xF5,0xD2,0x99,0x1D,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0xA6,0x84,0x84,0xA6,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0x84,0xA6,0xFF,0xFF,0x84,0x0,0x48,0xFF,0xFF,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x48,0xFF,0xFF,0x0,0x84,0xA6,0xFF,0xFF,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x84,0x84,0xFF,0xFF,0x48,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x11,0xFF,0xFF,0x40,0xB5,0x88,0xC9,0xFF,0xED,0xC,0xEB,0xFD,0xF7,0xC2,0x35,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x23,0xF1,0xFF,0xA3,0xFF,0xFF,0x48,0x7,0xCD,0xFF,0xCC,0x8,0xFF,0xFF,0x48,0x96,0xFF,0xE8,0x1C,0x0,0xFF,0xFF,0x9F,0xFF,0xFA,0x3C,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0xE1,0xD,0x0,0x0,0xFF,0xFF,0xB7,0xF9,0xFF,0xA3,0x0,0x0,0xFF,0xFF,0x48,0x74,0xFF,0xFF,0x5D,0x0,0xFF,0xFF,0x48,0x1,0xBD,0xFF,0xF3,0x24,0xFF,0xFF,0x48,0x0,0x1C,0xEE,0xFF,0xCC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0xCC,0xB8,0xB8,0xB8,0x5C,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xED,0xA,0x0,0x0,0x90,0xFF,0xFF,0x48,0xFF,0xFF,0xFF,0x68,0x0,0xE,0xF2,0xFF,0xFF,0x48,0xFF,0xFF,0xFF,0xD7,0x1,0x72,0xFF,0xFF,0xFF,0x48,0xFF,0xFF,0xCE,0xFF,0x4D,0xDF,0xCD,0xFF,0xFF,0x48,0xFF,0xFF,0x66,0xFC,0xEA,0xFF,0x62,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xAF,0xFF,0xED,0x9,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0x41,0xE0,0x80,0x0,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0x38,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0xFF,0xC1,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0xFA,0xFF,0x4A,0x48,0xFF,0xFF,0xFF,0xFF,0x96,0xFF,0xD1,0x4A,0xFF,0xFF,0xFF,0xFF,0x48,0xC6,0xFF,0xA5,0xFF,0xFF,0xFF,0xFF,0x48,0x3F,0xFF,0xFE,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0xB7,0xFF,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x31,0xFE,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x0,0xA8,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1D,0x9E,0xE6,0xFA,0xE5,0x9F,0x1D,0x0,0x1D,0xE8,0xFF,0xC9,0x8A,0xCB,0xFF,0xE8,0x1C,0x9F,0xFF,0xC6,0x4,0x0,0x3,0xC6,0xFF,0x9E,0xE6,0xFF,0x64,0x0,0x0,0x0,0x64,0xFF,0xE5,0xFB,0xFF,0x4B,0x0,0x0,0x0,0x4C,0xFF,0xFA,0xE6,0xFF,0x61,0x0,0x0,0x0,0x62,0xFF,0xE5,0x9E,0xFF,0xC4,0x3,0x0,0x3,0xC5,0xFF,0x9E,0x1D,0xE8,0xFF,0xC8,0x8A,0xCA,0xFF,0xE8,0x1D,0x0,0x1E,0x9F,0xE7,0xFB,0xE7,0x9F,0x1D,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0xF1,0xB7,0x2D,0x0,0xFF,0xFF,0xA7,0x8D,0xD8,0xFF,0xE9,0xA,0xFF,0xFF,0x48,0x0,0x18,0xFF,0xFF,0x3E,0xFF,0xFF,0x48,0x0,0x1C,0xFF,0xFF,0x2F,0xFF,0xFF,0xA6,0x89,0xD9,0xFF,0xC4,0x1,0xFF,0xFF,0xFF,0xFF,0xE7,0x95,0x10,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1C,0x9D,0xE6,0xFA,0xE5,0x9D,0x1C,0x0,0x1B,0xE6,0xFF,0xD0,0x8A,0xBA,0xFF,0xE6,0x1B,0x9C,0xFF,0xC9,0x5,0x0,0x0,0x98,0xFF,0x9C,0xE5,0xFF,0x64,0x0,0x0,0x0,0x2F,0xFF,0xE4,0xFB,0xFF,0x4B,0x0,0x0,0x0,0x14,0xFF,0xFB,0xE9,0xFF,0x63,0x0,0x0,0x0,0x2C,0xFF,0xEC,0xA3,0xFF,0xC9,0x5,0x0,0x0,0x98,0xFF,0xAE,0x22,0xED,0xFF,0xCF,0x8A,0xB8,0xFF,0xFA,0x36,0x0,0x24,0xA9,0xEC,0xFF,0xFF,0xEA,0x46,0x0,0x0,0x0,0x0,0x0,0x93,0xFF,0xF2,0x8E,0x84,0x0,0x0,0x0,0x0,0x15,0xB1,0xF5,0xFE,0xEC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0xF7,0xCC,0x4A,0x0,0x0,0xFF,0xFF,0xA6,0x87,0xC0,0xFF,0xF9,0x1A,0x0,0xFF,0xFF,0x48,0x0,0xA,0xFF,0xFF,0x3F,0x0,0xFF,0xFF,0x48,0x5,0x5E,0xFF,0xF9,0x16,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0xF6,0x60,0x0,0x0,0xFF,0xFF,0xA6,0xD1,0xFF,0xE1,0x13,0x0,0x0,0xFF,0xFF,0x48,0x20,0xED,0xFF,0xB8,0x2,0x0,0xFF,0xFF,0x48,0x0,0x4A,0xFE,0xFF,0x81,0x0,0xFF,0xFF,0x48,0x0,0x0,0x83,0xFF,0xFE,0x4A,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x74,0xD5,0xFA,0xF6,0xD3,0x8B,0x0,0x99,0xFF,0xDE,0x8D,0x96,0xDB,0xEC,0x0,0xF5,0xFF,0x55,0x0,0x0,0x1,0x4E,0x0,0xDC,0xFF,0xF5,0xB4,0x7C,0x2F,0x0,0x0,0x4C,0xF2,0xFF,0xFF,0xFF,0xFF,0x9B,0x0,0x0,0x10,0x5E,0x99,0xE1,0xFF,0xFF,0x2D,0x7D,0x7,0x0,0x0,0x14,0xFF,0xFF,0x3A,0xFF,0xE8,0x9F,0x89,0xC3,0xFF,0xD4,0x4,0x89,0xD1,0xF5,0xFC,0xE3,0x97,0x15,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x84,0x84,0xA6,0xFF,0xFF,0x84,0x84,0x84,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x0,0x48,0xFF,0xFF,0xFE,0xFF,0x4C,0x0,0x0,0x4A,0xFF,0xFE,0xE5,0xFF,0x88,0x0,0x0,0x83,0xFF,0xE3,0x7D,0xFF,0xFF,0xCC,0xC8,0xFE,0xFF,0x7D,0x1,0x6E,0xD2,0xF8,0xF8,0xD3,0x71,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xE9,0xFF,0x87,0x0,0x0,0x0,0xB3,0xFF,0xB1,0x91,0xFF,0xDC,0x0,0x0,0xF,0xF9,0xFF,0x55,0x34,0xFF,0xFF,0x34,0x0,0x5F,0xFF,0xF0,0x8,0x0,0xD7,0xFF,0x8A,0x0,0xB5,0xFF,0x9C,0x0,0x0,0x7A,0xFF,0xE0,0x11,0xFA,0xFF,0x3F,0x0,0x0,0x1F,0xFE,0xFF,0x99,0xFF,0xE1,0x1,0x0,0x0,0x0,0xC0,0xFF,0xFF,0xFF,0x86,0x0,0x0,0x0,0x0,0x63,0xFF,0xFF,0xFF,0x2A,0x0,0x0,0x0,0x0,0xF,0xF7,0xFF,0xCE,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xAE,0xFF,0xC3,0x0,0x0,0x96,0xFF,0xF9,0xA,0x0,0x59,0xFF,0xFB,0x6A,0xFF,0xF6,0x4,0x0,0xDA,0xFF,0xFF,0x44,0x0,0x93,0xFF,0xC6,0x26,0xFF,0xFF,0x31,0x1D,0xFF,0xFF,0xFF,0x84,0x0,0xCD,0xFF,0x82,0x0,0xE2,0xFF,0x68,0x61,0xFF,0xEA,0xFF,0xC4,0xA,0xFB,0xFF,0x3E,0x0,0x9E,0xFF,0x9F,0xA5,0xFF,0x70,0xFD,0xFA,0x4A,0xFF,0xF4,0x5,0x0,0x5A,0xFF,0xD7,0xE7,0xFF,0x1C,0xC9,0xFF,0xBF,0xFF,0xB6,0x0,0x0,0x17,0xFE,0xFF,0xFF,0xD8,0x0,0x83,0xFF,0xFF,0xFF,0x72,0x0,0x0,0x0,0xD2,0xFF,0xFF,0x95,0x0,0x3D,0xFF,0xFF,0xFF,0x2E,0x0,0x0,0x0,0x8E,0xFF,0xFF,0x51,0x0,0x4,0xF2,0xFF,0xE9,0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xA0,0xFF,0xF7,0x24,0x0,0x20,0xF4,0xFF,0x89,0x11,0xE6,0xFF,0xBB,0x0,0xB9,0xFF,0xD3,0x7,0x0,0x50,0xFF,0xFF,0xAC,0xFF,0xFA,0x32,0x0,0x0,0x0,0xA7,0xFF,0xFF,0xFF,0x7F,0x0,0x0,0x0,0x0,0x2E,0xFF,0xFF,0xFC,0x18,0x0,0x0,0x0,0x0,0xB5,0xFF,0xFF,0xFF,0xA6,0x0,0x0,0x0,0x63,0xFF,0xFA,0x88,0xFF,0xFF,0x4F,0x0,0x1E,0xF1,0xFF,0x84,0x0,0xBA,0xFF,0xE7,0x11,0xBC,0xFF,0xD7,0x7,0x0,0x22,0xF6,0xFF,0xA3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xEE,0xFF,0xA8,0x0,0x0,0x59,0xFF,0xFE,0x66,0xFF,0xFF,0x38,0x5,0xDD,0xFF,0x9C,0x1,0xC6,0xFF,0xC7,0x6D,0xFF,0xEA,0x12,0x0,0x2D,0xFB,0xFF,0xF9,0xFF,0x5C,0x0,0x0,0x0,0x89,0xFF,0xFF,0xBC,0x0,0x0,0x0,0x0,0xA,0xFF,0xFF,0x4C,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0x84,0x84,0x84,0x87,0xF8,0xFF,0xEA,0x0,0x0,0x0,0x0,0x7D,0xFF,0xFF,0x4E,0x0,0x0,0x0,0x35,0xFB,0xFF,0x9A,0x0,0x0,0x0,0xA,0xD9,0xFF,0xDA,0xB,0x0,0x0,0x0,0x97,0xFF,0xFB,0x35,0x0,0x0,0x0,0x4A,0xFF,0xFF,0x7D,0x0,0x0,0x0,0x0,0xE8,0xFF,0xF8,0x87,0x84,0x84,0x84,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0x58,0xFF,0xFF,0xA6,0x84,0x2D,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0xA6,0x84,0x2D,0xFF,0xFF,0xFF,0xFF,0x58,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x9A,0xFF,0x3D,0x0,0x0,0x0,0x47,0xFF,0x90,0x0,0x0,0x0,0x5,0xEE,0xE2,0x1,0x0,0x0,0x0,0x9F,0xFF,0x36,0x0,0x0,0x0,0x4B,0xFF,0x89,0x0,0x0,0x0,0x6,0xF0,0xDC,0x0,0x0,0x0,0x0,0xA4,0xFF,0x2F,0x0,0x0,0x0,0x50,0xFF,0x83,0x0,0x0,0x0,0x8,0xF3,0xD6,0x0,0x0,0x0,0x0,0xA8,0xFF,0x29,0x0,0x0,0x0,0x54,0xFF,0x7C,0x0,0x0,0x0,0xA,0x80,0x5D,
	0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0x48,0x84,0x84,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x84,0x84,0xFF,0xFF,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9,0xD8,0xFF,0x56,0x0,0x0,0x0,0x0,0x0,0x8E,0xFF,0xF0,0xEF,0x1D,0x0,0x0,0x0,0x3C,0xFD,0xB3,0x3A,0xFC,0xC0,0x2,0x0,0xA,0xDB,0xF1,0x1B,0x0,0x81,0xFF,0x7A,0x0,0x92,0xFF,0x67,0x0,0x0,0x4,0xC7,0xFA,0x35,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0xB1,0xFE,0x37,0x9,0xC7,0xCE,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x42,0xD4,0xF4,0xFC,0xEA,0xAD,0x24,0x5C,0xC1,0x8D,0x91,0xE0,0xFF,0xCF,0x0,0x11,0x4C,0x6A,0xA1,0xFF,0xFE,0x65,0xF8,0xFF,0xE0,0xD6,0xFF,0xFF,0xEF,0xFF,0x69,0x0,0x48,0xFF,0xFF,0xE4,0xFF,0xBD,0x76,0xC5,0xFF,0xFF,0x42,0xDB,0xFC,0xCE,0x8D,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x93,0xD4,0xF9,0xBD,0x15,0xFF,0xFF,0xC9,0x8E,0xEA,0xFF,0xA0,0xFF,0xFF,0x48,0x0,0x65,0xFF,0xEA,0xFF,0xFF,0x48,0x0,0x4B,0xFF,0xFB,0xFF,0xFF,0x48,0x0,0x76,0xFF,0xDE,0xFF,0xFF,0xB1,0x92,0xF4,0xFF,0x79,0xFF,0xFF,0xC3,0xF3,0xF0,0x8A,0x3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x56,0xC5,0xF4,0xF7,0xCB,0x46,0x61,0xFF,0xFD,0xA3,0x8E,0xD8,0x80,0xDA,0xFF,0x89,0x0,0x0,0x4,0x25,0xFA,0xFF,0x4E,0x0,0x0,0x0,0x0,0xDE,0xFF,0x7E,0x0,0x0,0x2,0x23,0x68,0xFF,0xFC,0xA8,0x8C,0xD1,0x80,0x0,0x58,0xC8,0xF5,0xFB,0xD0,0x4A,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x0,0x48,0xFF,0xFF,0x4,0x8A,0xEE,0xF3,0xCB,0xFF,0xFF,0x7A,0xFF,0xF6,0x95,0xB6,0xFF,0xFF,0xDF,0xFF,0x7D,0x0,0x48,0xFF,0xFF,0xFB,0xFF,0x4D,0x0,0x48,0xFF,0xFF,0xE9,0xFF,0x65,0x0,0x48,0xFF,0xFF,0x9A,0xFF,0xEB,0x8F,0xCC,0xFF,0xFF,0x11,0xB5,0xFA,0xDE,0x9F,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x65,0xD4,0xF9,0xED,0x9E,0xD,0x6A,0xFF,0xDB,0x8C,0xD4,0xFF,0x9C,0xDC,0xFF,0xAD,0x84,0xAC,0xFF,0xED,0xFB,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xDF,0xFF,0x69,0x0,0x0,0x0,0x1F,0x6D,0xFF,0xF7,0x9E,0x87,0xB1,0xFB,0x0,0x5E,0xC8,0xF5,0xFD,0xE1,0x9D,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x81,0xE2,0xFC,0xFA,0x75,0x37,0xFF,0xFD,0x93,0x84,0x42,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0xA6,0xFF,0xFF,0x84,0x84,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5,0x93,0xF0,0xF2,0xC4,0xFF,0xFF,0x82,0xFF,0xF6,0x94,0xB5,0xFF,0xFF,0xE1,0xFF,0x7C,0x0,0x48,0xFF,0xFF,0xFC,0xFF,0x4D,0x0,0x48,0xFF,0xFF,0xEA,0xFF,0x66,0x0,0x48,0xFF,0xFF,0xA0,0xFF,0xE9,0x8C,0xCD,0xFF,0xFF,0x13,0xB0,0xF7,0xE8,0xBA,0xFF,0xEC,0x2F,0xA0,0x87,0x8D,0xDC,0xFF,0x99,0x32,0xDC,0xF9,0xFC,0xE1,0x8E,0x9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x80,0xC3,0xF9,0xDA,0x3D,0xFF,0xFF,0xF8,0xCB,0xF6,0xFF,0xD5,0xFF,0xFF,0x4F,0x0,0x67,0xFF,0xFD,0xFF,0xFF,0x48,0x0,0x49,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0xFF,0xFF,0x48,0x84,0x84,0x25,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x84,0x84,0x25,0x2C,0xFF,0xFF,0xFF,0x48,0x16,0x84,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0xE,0xFF,0xFF,0x46,0x84,0xB4,0xFF,0xFD,0x21,0xF0,0xFE,0xE6,0x65,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x18,0xE6,0xFF,0x96,0xFF,0xFF,0x4B,0xC0,0xFF,0xBE,0x4,0xFF,0xFF,0xCA,0xFF,0xDD,0x13,0x0,0xFF,0xFF,0xFF,0xFF,0xD1,0x5,0x0,0xFF,0xFF,0x70,0xEF,0xFF,0x82,0x0,0xFF,0xFF,0x48,0x66,0xFF,0xFB,0x32,0xFF,0xFF,0x48,0x1,0xC3,0xFF,0xD3,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x9A,0xDB,0xF5,0x8B,0x4F,0xD7,0xF6,0x86,0x0,0xFF,0xFF,0xDE,0xBC,0xFF,0xFF,0xDE,0xBC,0xFF,0xFF,0x25,0xFF,0xFF,0x48,0x5,0xFF,0xFF,0x48,0x5,0xFF,0xFF,0x45,0xFF,0xFF,0x48,0x0,0xFF,0xFF,0x48,0x0,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0x0,0xFF,0xFF,0x48,0x0,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0x0,0xFF,0xFF,0x48,0x0,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0x0,0xFF,0xFF,0x48,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x94,0xCB,0xFA,0xDA,0x3D,0xFF,0xFF,0xE7,0xA7,0xE7,0xFF,0xD5,0xFF,0xFF,0x48,0x0,0x5E,0xFF,0xFD,0xFF,0xFF,0x48,0x0,0x49,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x71,0xDB,0xFA,0xE9,0x9A,0x10,0x0,0x75,0xFF,0xED,0x8C,0xD1,0xFF,0xBC,0x0,0xE0,0xFF,0x6D,0x0,0x27,0xFF,0xFF,0x27,0xFB,0xFF,0x4B,0x0,0x3,0xFF,0xFF,0x42,0xDF,0xFF,0x6C,0x0,0x24,0xFF,0xFF,0x27,0x75,0xFF,0xEC,0x8C,0xD1,0xFF,0xBC,0x0,0x1,0x71,0xDB,0xFB,0xEA,0x9A,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xA0,0xD9,0xF9,0xBD,0x15,0xFF,0xFF,0xC9,0x8E,0xEA,0xFF,0xA0,0xFF,0xFF,0x48,0x0,0x65,0xFF,0xEA,0xFF,0xFF,0x48,0x0,0x4B,0xFF,0xFB,0xFF,0xFF,0x48,0x0,0x76,0xFF,0xDE,0xFF,0xFF,0xAF,0x92,0xF4,0xFF,0x79,0xFF,0xFF,0xCB,0xF3,0xF0,0x8A,0x3,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x8A,0xEE,0xF1,0xC3,0xFF,0xFF,0x7A,0xFF,0xF6,0x95,0xB6,0xFF,0xFF,0xDF,0xFF,0x7D,0x0,0x48,0xFF,0xFF,0xFB,0xFF,0x4D,0x0,0x48,0xFF,0xFF,0xE9,0xFF,0x65,0x0,0x48,0xFF,0xFF,0x9A,0xFF,0xEB,0x8F,0xCC,0xFF,0xFF,0x11,0xB5,0xFA,0xDD,0x9C,0xFF,0xFF,0x0,0x0,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x9E,0xD4,0xFD,0xFF,0xFF,0xCA,0x8D,0x84,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1E,0xA6,0xEA,0xFC,0xE8,0xAB,0xD2,0xFF,0xDE,0x8A,0xA4,0xF3,0xEF,0xFF,0xC5,0x4E,0x17,0x13,0x5F,0xF2,0xFF,0xFF,0xFE,0x90,0x27,0xA,0x40,0x95,0xFF,0xF6,0xFB,0xB4,0x88,0xB8,0xFF,0xCD,0xA1,0xE4,0xFC,0xEE,0xAB,0x1E,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0xA6,0xFF,0xFF,0x84,0x84,0x48,0xFF,0xFF,0x0,0x0,0x48,0xFF,0xFF,0x0,0x0,0x47,0xFF,0xFF,0x3,0x0,0x2D,0xFF,0xFF,0xA4,0x80,0x0,0x8A,0xEE,0xFD,0xE6,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x48,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x48,0xFF,0xFF,0xFF,0xFF,0x48,0x0,0x48,0xFF,0xFF,0xFD,0xFF,0x57,0x0,0x48,0xFF,0xFF,0xD5,0xFF,0xE5,0xA7,0xE6,0xFF,0xFF,0x3D,0xD9,0xFA,0xCE,0x95,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xD1,0xFF,0x80,0x0,0x2,0xE9,0xFF,0x55,0x74,0xFF,0xD0,0x0,0x3C,0xFF,0xEF,0x7,0x1A,0xFD,0xFF,0x20,0x8B,0xFF,0x9A,0x0,0x0,0xBA,0xFF,0x71,0xDA,0xFF,0x3D,0x0,0x0,0x5D,0xFF,0xE0,0xFF,0xDF,0x1,0x0,0x0,0xB,0xF4,0xFF,0xFF,0x83,0x0,0x0,0x0,0x0,0xA3,0xFF,0xFF,0x26,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xC2,0xFF,0x8D,0x0,0x46,0xFF,0xF4,0x6,0x1,0xEC,0xFF,0x52,0x77,0xFF,0xC9,0x0,0x91,0xFF,0xFF,0x41,0x2A,0xFF,0xF9,0xC,0x2C,0xFF,0xFA,0xA,0xDC,0xEC,0xFF,0x87,0x66,0xFF,0xBA,0x0,0x0,0xE0,0xFF,0x68,0xFF,0x80,0xED,0xCD,0xA1,0xFF,0x6E,0x0,0x0,0x95,0xFF,0xE5,0xFF,0x36,0xA9,0xFE,0xE8,0xFF,0x22,0x0,0x0,0x49,0xFF,0xFF,0xEC,0x2,0x62,0xFF,0xFF,0xD6,0x0,0x0,0x0,0x8,0xF5,0xFF,0xA7,0x0,0x1C,0xFF,0xFF,0x8A,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x9E,0xFF,0xE5,0x10,0x1B,0xEF,0xFF,0x7B,0xA,0xD6,0xFF,0xA3,0xB9,0xFF,0xB9,0x1,0x0,0x2D,0xF7,0xFF,0xFF,0xE5,0x15,0x0,0x0,0x0,0x97,0xFF,0xFF,0x73,0x0,0x0,0x0,0x30,0xF7,0xFF,0xFF,0xEC,0x1C,0x0,0xD,0xDA,0xFF,0x91,0xBA,0xFF,0xC3,0x3,0xA7,0xFF,0xD7,0x8,0x1D,0xF1,0xFF,0x85,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xCF,0xFF,0x7E,0x0,0x5,0xEE,0xFF,0x4C,0x68,0xFF,0xDA,0x0,0x4B,0xFF,0xE2,0x3,0xD,0xF3,0xFF,0x38,0xA2,0xFF,0x80,0x0,0x0,0x98,0xFF,0x9D,0xF1,0xFC,0x1D,0x0,0x0,0x30,0xFF,0xFE,0xFF,0xB3,0x0,0x0,0x0,0x0,0xC8,0xFF,0xFF,0x4D,0x0,0x0,0x0,0x0,0x83,0xFF,0xE3,0x3,0x0,0x0,0x0,0x1,0xDA,0xFF,0x81,0x0,0x0,0x0,0x0,0x46,0xFF,0xFD,0x1D,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x84,0x84,0x84,0xF0,0xFF,0xCF,0x0,0x0,0x78,0xFF,0xED,0x21,0x0,0x46,0xFD,0xFC,0x45,0x0,0x21,0xED,0xFF,0x77,0x0,0x0,0xD0,0xFF,0xF0,0x84,0x84,0x84,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3E,0xCC,0xFA,0xFF,0x9C,0x0,0x0,0x0,0xE6,0xFF,0xDB,0x8B,0x50,0x0,0x0,0x0,0xFF,0xFF,0x50,0x0,0x0,0x0,0x0,0x20,0xFF,0xFF,0x3C,0x0,0x0,0x42,0x8F,0xDC,0xFA,0x8F,0x1,0x0,0x0,0x80,0xFF,0xFF,0x9C,0x15,0x0,0x0,0x0,0x0,0xD,0x81,0xFF,0xE4,0x10,0x0,0x0,0x0,0x0,0x9,0xFF,0xFF,0x45,0x0,0x0,0x0,0x0,0x0,0xFF,0xFF,0x54,0x0,0x0,0x0,0x0,0x0,0xDC,0xFF,0xE0,0x8B,0x50,0x0,0x0,0x0,0x37,0xC9,0xFA,0xFF,0x9C,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0xFF,0xFF,0x48,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x54,0xFF,0xFD,0xDF,0x6E,0x0,0x0,0x0,0x2B,0x86,0xBE,0xFF,0xFF,0x2E,0x0,0x0,0x0,0x0,0x9,0xFF,0xFF,0x48,0x0,0x0,0x0,0x0,0x0,0xF4,0xFF,0x63,0x0,0x0,0x0,0x0,0x0,0x58,0xEB,0xED,0x94,0x42,0x0,0x0,0x0,0x4,0x6F,0xF7,0xFF,0x80,0x0,0x0,0x0,0xAD,0xFF,0xB0,0x13,0x0,0x0,0x0,0x0,0xFD,0xFF,0x4F,0x0,0x0,0x0,0x0,0xE,0xFF,0xFF,0x47,0x0,0x0,0x2B,0x86,0xC4,0xFF,0xFE,0x24,0x0,0x0,0x54,0xFF,0xFD,0xDE,0x66,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
	0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10,0xB8,0xF9,0xC8,0x25,0x0,0x0,0xFF,0xFF,0x41,0x92,0xFF,0xD8,0xAA,0xDF,0x11,0x10,0xFF,0xFF,0x24,0xDE,0xFF,0x58,0x0,0xA4,0xCD,0xB4,0xFF,0xD9,0x0,0xFA,0xFF,0x48,0x0,0x8,0xA5,0xF9,0xD9,0x37,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
};
#endif



//*******************************************************************************
void	dispPutC(unsigned char ch, unsigned int x_pos,unsigned int y_pos,COLOR fc, COLOR bc)
{
unsigned int	x,shifted,on_off,letter;
unsigned int	row,byte;

	letter	=	ch - (32);		//*	adjust for space = 0 offset in table

	letter	=	(letter * 7);	//*	7 bytes per letter definition

	dispColor(fc);


	for (row=0;row<7;row++)
	{
		byte	=	pgm_read_byte(gFont_5x7 + letter + row);

		shifted	=	byte;
		
		for (x=0;x<5;x++)
		{
			
			//oled_setXY(x_pos+x, y_pos+row);

			on_off	=	shifted & B10000000;
			on_off	=	on_off >> 7; 
			shifted	=	shifted << 1;
			if (on_off > 0)
			{
				dispColor(fc);
				dispPixel(x_pos + x, y_pos + row); //write the pixel
			}
			else
			{
				dispColor(bc);
				dispPixel(x_pos + x, y_pos + row); //write the pixel
			}
			
		}
	}
}

//*******************************************************************************
void	dispPutS(char * string, unsigned int x_pos, unsigned int y_pos, COLOR fc, COLOR bc)
{
	while(*string)
	{
		dispPutC(*string++,x_pos,y_pos,fc, bc);
		x_pos	=	x_pos + 6;
	}
}


//*******************************************************************************
int		dispMeasureC(unsigned char ch)
{
	return 6;
}

//*******************************************************************************
int		dispMeasureS(char * string)
{
	int w	=	0;
	while(*string)
	{
		*string++;
		w	=	w + 6;
	}
	return w - 1;
}


#pragma mark -
#pragma mark Tahmoa font support routines

#ifdef _ENABLE_TAHOMA_FONTS_

//*******************************************************************************
int		dispPutC1(unsigned char ch, unsigned int x_pos,unsigned int y_pos,COLOR fc, COLOR bc)
{
int	charIndex;		// Where in the array is the character ?
int	charStart;				// Where does the character start?
int	charWidth;
int	ii;
int	jj;

	charIndex	=	ch - (33);
	charStart	=	0;
	charWidth	=	0;
	
	if (charIndex == -1) return 6;	// It's a space, just return 6 and be done w/ it

	// Out of range, use ?
	if (charIndex < 0 || charIndex > 94) charIndex	=	29;

	// Get the characters width
	charWidth	=	pgm_read_byte(font1_sizes + charIndex);

	// Figure out where the character starts
	for (ii = 0; ii < charIndex; ii++)
	{
		charStart	=	charStart + (pgm_read_byte(font1_sizes + ii) * 13);
	}

	// Set Window
	//dispSetWindow(x_pos,y_pos,charWidth-1,13);

	// Display Character
	for (jj = 0; jj < 13; jj++)
	{
		for (ii = 0; ii < charWidth; ii++)
		{
			dispColor(alphaBlend(fc, bc, pgm_read_byte(font1_data + charStart)));
			dispPixel(x_pos + ii, y_pos + jj);
			//dispPix();	// Faster but doesn't work in Portrait Mode
			charStart++;
		}
	}

	return charWidth + 1;
}

//*******************************************************************************
int		dispPutS1(char * string, unsigned int x_pos, unsigned int y_pos, COLOR fc, COLOR bc)
{
	int ww	=	0;
	while(*string)
	{
		ww	=	ww + dispPutC1(*string++, x_pos + ww, y_pos, fc, bc) + 1;
	}
	return ww;
}

//*******************************************************************************
int		dispMeasureC1(unsigned char ch)
{
	int charIndex	=	ch - (33);		// Where in the array is the character ?
	int charStart	=	0;				// Where does the character start?

	if (charIndex == -1) return 6;	// It's a space, just return 6 and be done w/ it

	// Out of range, use ?
	if (charIndex < 0 || charIndex > 94) charIndex	=	29;

	return pgm_read_byte(font1_sizes + charIndex);
}

//*******************************************************************************
int		dispMeasureS1(char * string)
{
	int w	=	0;
	while(*string)
	{
		w	=	w + dispMeasureC1(*string++) + 2;
	}
	return w - 2;
}

//*******************************************************************************
int		dispPutC2(unsigned char ch, unsigned int x_pos,unsigned int y_pos,COLOR fc, COLOR bc)
{
	int charIndex	=	ch - (33);		// Where in the array is the character ?
	int charStart	=	0;				// Where does the character start?
	int charWidth	=	0;
	int ii;
	int jj;

	if (charIndex == -1) return 6;	// It's a space, just return 6 and be done w/ it

	// Out of range, use ?
	if (charIndex < 0 || charIndex > 94) charIndex	=	29;

	// Get the characters width
	charWidth	=	pgm_read_byte(font2_sizes + charIndex);

	// Figure out where the character starts
	for (ii = 0; ii < charIndex; ii++)
	{
		charStart	=	charStart + (pgm_read_byte(font2_sizes + ii) * 13);
	}

	// Set Window
	//dispSetWindow(x_pos, y_pos, charWidth-1, 13);

	// Display Character
	for (jj = 0; jj < 13; jj++)
	{
		for (ii	=	0; ii < charWidth; ii++)
		{
			dispColor(alphaBlend(fc, bc, pgm_read_byte(font2_data + charStart)));
			dispPixel(x_pos + ii, y_pos + jj);
			//dispPix();	// Faster but doesn't work in Portrait Mode
			charStart++;
		}
	}

	return charWidth + 1;
}

//*******************************************************************************
int		dispPutS2(char * string, unsigned int x_pos, unsigned int y_pos, COLOR fc, COLOR bc)
{
	int w	=	0;
	while(*string)
	{
		w	=	w + dispPutC2(*string++,x_pos + w,y_pos,fc, bc) + 1;
	}
	return w;
}

//*******************************************************************************
int		dispMeasureC2(unsigned char ch)
{
	int charIndex	=	ch - (33);		// Where in the array is the character ?
	int charStart	=	0;				// Where does the character start?

	if (charIndex == -1) return 6;	// It's a space, just return 6 and be done w/ it

	// Out of range, use ?
	if (charIndex < 0 || charIndex > 94) charIndex	=	29;

	return pgm_read_byte(font2_sizes + charIndex);
}

//*******************************************************************************
int		dispMeasureS2(char * string)
{
	int w	=	0;
	while(*string)
	{
		w	=	w + dispMeasureC2(*string++) + 2;
	}
	return w - 2;
}

//*******************************************************************************
int		alphaBlendVal(float fgcolor, float bgcolor, float a)
{
float	p1;
float	p2;

	if (a >= 90) return fgcolor;
	if (a <= 10) return bgcolor;
	
	p1	=	(100 - a) / 100;
	p2	=	a / 100;
	
	return (bgcolor * p1) + (fgcolor * p2);
}

//*******************************************************************************
COLOR	alphaBlend(COLOR forecolor, COLOR backcolor, int opacity)
{
  COLOR reslt;

  reslt.red		=	alphaBlendVal(forecolor.red, backcolor.red, opacity);
  reslt.green	=	alphaBlendVal(forecolor.green, backcolor.green, opacity);
  reslt.blue	=	alphaBlendVal(forecolor.blue, backcolor.blue, opacity);
  return reslt;
}
#endif		//	_ENABLE_TAHOMA_FONTS_

//*******************************************************************************
