//************************************************************************
//					Nokia Shield
//************************************************************************
//*	Edit History
//*		<MLS>	= Mark Sproul msproul -at- jove.rutgers.edu
//************************************************************************
//*	Apr  2,	2010	<MLS> I received my Color LCD Shield sku: LCD-09363 from sparkfun
//*	Apr  2,	2010	<MLS> The code was written for WinAVR, I modified it to compile under Arduino
//*	Apr  3,	2010	<MLS> Changed LCDSetPixel to make it "RIGHT" side up
//************************************************************************

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>


#include	"WProgram.h"
#include	"HardwareSerial.h"


//************************************************************************
//					External Component Libs
//************************************************************************
#include "LCD_driver.h"
#include "nokia_tester.h"

//static int uart_putchar(char c, FILE *stream);
//uint8_t uart_getchar(void);
//static FILE mystdout	=	FDEV_SETUP_STREAM(uart_putchar, NULL, _FDEV_SETUP_WRITE);

#define _SHOW_RGB_IMAGE_
void	DisplayRGBimage();


#define	kSwitch1_PIN	3
#define	kSwitch2_PIN	4
#define	kSwitch3_PIN	5

void	DoMandleBrot(void);

//#define	_ENABLE_DEBUG_

//************************************************************************
//					Main Code
//************************************************************************
void	setup()
{
int	frameCounter;
unsigned long	startTime;

	Serial.begin(9600);
	Serial.println("Initializing");
	
	//Initialize ARM I/O
	ioinit();
	
	Serial.println("ioinit. Done");
	
	LCDInit();			//Initialize the LCD
	
	Serial.println("LCDInit. Done");
	
	LCDClear(BLACK);
	Serial.print("Logo...");
	//Show the splash-screen (Sparkfun Logo)
	LCDPrintLogo();

#ifdef _ENABLE_DEBUG_
	//*	test speed
	Serial.println();
	Serial.print("Speed test...");
	frameCounter	=	0;
	startTime		=	millis();
	
	while ((millis() - startTime) < 5000)
	{
		LCDClear((frameCounter << 8) + frameCounter);
		LCDPrintLogo();
	
		frameCounter++;
	}
	Serial.println();
	Serial.print("Frames=");
	Serial.println(frameCounter);
#endif
}

//************************************************************************
//					Loop
//************************************************************************
void	loop()
{
int	s1, s2, s3;

	s1	=	!digitalRead(kSwitch1_PIN);
	s2	=	!digitalRead(kSwitch2_PIN);
	s3	=	!digitalRead(kSwitch3_PIN);
#ifdef _ENABLE_DEBUG_foo
	Serial.print("switches...");
	Serial.print(s1);
	Serial.print("...");
	Serial.print(s2);
	Serial.print("...");
	Serial.print(s3);
	Serial.println();
#endif


	if (s1)
	{
		Serial.println("GRREN");
		LCDClear(GREEN);
		LCDPrintLogo();
	}
	else if (s2)
	{
		Serial.println("WHITE");
	//	LCDClear(PINK);
		LCDClear(WHITE);
		LCDPrintLogo();
	}
	else if (s3)
	{
		DisplayRGBimage();
		delay(5000);
		
	//	Serial.println("BLACK");
	//	LCDClear(BLACK);
	//	LCDPrintLogo();
		DoMandleBrot();
	}
	delay(200);
}

//************************************************************************
void ioinit(void)
{
#ifdef _USE_ARDUINO_FOR_NOKIEA_

	//*	setup the switches for input
	pinMode(kSwitch1_PIN, INPUT);
	pinMode(kSwitch2_PIN, INPUT);
	pinMode(kSwitch3_PIN, INPUT);

	//*	set the pull up resisters
	digitalWrite(kSwitch1_PIN, HIGH);
	digitalWrite(kSwitch2_PIN, HIGH);
	digitalWrite(kSwitch3_PIN, HIGH);


	//*	do the LCD control lines
	pinMode(CS_PIN,			OUTPUT);
	pinMode(DIO_PIN,		OUTPUT);
	pinMode(SCK_PIN,		OUTPUT);
	pinMode(LCD_RES_PIN,	OUTPUT);

#else
	DDRB	=	((1<<CS)|(1<<DIO)|(1<<SCK)|(1<<LCD_RES));	//Set the control pins as outputs

	// USART Baud rate: 115200 (With 16 MHz Clock)
	UBRR0H	=	(MYUBRR >> 8) & 0x7F;	//Make sure highest bit(URSEL) is 0 indicating we are writing to UBRRH
	UBRR0L	=	MYUBRR;
	UCSR0A	=	(1<<U2X0);					//Double the UART Speed
	UCSR0B	=	(1<<RXEN0)|(1<<TXEN0);		//Enable Rx and Tx in UART
	UCSR0C	=	(1<<UCSZ00)|(1<<UCSZ01);		//8-Bit Characters
//	stdout	=	&mystdout; //Required for printf init
	cli();
	
	// Arduino D3-5 are button pins
	// This is PD3-5
	DDRD	=	0x00;
	PORTD	=	0xFF;
	
	// Init timer 2
	//Set Prescaler to 8. (Timer Frequency set to 16Mhz)
	//Used for delay routines
	TCCR2B	=	(1<<CS20); 	//Divde clock by 1 for 16 Mhz Timer 2 Frequency	
#endif


}


#if 0
//************************************************************************
static int uart_putchar(char c, FILE *stream)
{
	if (c == '\n')
		uart_putchar('\r', stream);
	
	loop_until_bit_is_set(UCSR0A, UDRE0);
	UDR0	=	c;
	return 0;
}

//************************************************************************
uint8_t uart_getchar(void)
{
	while( !(UCSR0A & (1<<RXC0)) );
	return(UDR0);
}

//************************************************************************
//General short delays
void delay_ms(int x)
{
	for (; x > 0 ; x--)
		delay_us(1000);
}

//************************************************************************
//General short delays
void delay_us(int x)
{	
	TIFR2	=	(1<<TOV2); //Clear any interrupt flags on Timer2
	TCNT2= 240; //Setting counter to 239 will make it 16 ticks until TOV is set. .0625uS per click means 1 uS until TOV is set
	while(x>0)
	{
		while( (TIFR2 & (1<<TOV2)) == 0);
		TIFR2	=	(1<<TOV2); //Clear any interrupt flags on Timer2
		TCNT2=240;
		x--;
	}
}
#endif

#pragma mark -



#define		kQmax				(COL_HEIGHT + 10)
#define		kStartColor			1
#define		kMaxItterations		255

#define		kMandel_FarLeft		-2.01
#define		kMandel_FarRight	1.0
#define		kMandel_FarTop		-1.2
#define		kMandel_FarBottom	1.2


int	gWidth	=	ROW_LENGTH;
int	gHeight	=	COL_HEIGHT;

//*******************************************************************************
void	setPixel(int col, int row, RGBColor *rgbColor)
{
int color12bit;

	color12bit	=	(rgbColor->red << 4) & 0x0f00;
	color12bit	+=	(rgbColor->green) & 0x0f0;
	color12bit	+=	(rgbColor->blue >> 4) & 0x0f;
	
	LCDSetPixel(color12bit, col, row);
//	LCDSetPixel(color12bit, row, col);
}

//*******************************************************************************
boolean	gettouch()
{
int	s1, s2, s3;

	s1	=	!digitalRead(kSwitch1_PIN);
	s2	=	!digitalRead(kSwitch2_PIN);
	s3	=	!digitalRead(kSwitch3_PIN);

	return(s1 || s2 || s3);
}


//*******************************************************************************
void	DoMandleBrot(void)
{
float		XMax, YMax, XMin, YMin;
float		X, Y, Xsquare, Ysquare;
float		QQtemp;
float		QQ[kQmax];
float 		PP, deltaP, deltaQ;
long		color;
short		row, col;
short		maxcol;
short		maxrow;
RGBColor	rgbColor;
short		itteration;
boolean		keepGoing;
short		deltaColumn;
short		ii;
short		startOffset[10]	=	{0,  16, 8,  4, 2, 1, 3, 0};
short		columnSteps[10]	=	{32, 32, 16, 8, 4, 4, 4, 0};

	XMin	=	kMandel_FarLeft;
	XMax	=	kMandel_FarRight;
	YMin	=	kMandel_FarTop;
	YMax	=	kMandel_FarBottom;

	itteration	=	0;
	keepGoing	=	true;
	while (keepGoing)
	{
		switch(itteration % 3)
		{
			case 0:
				XMin	=	kMandel_FarLeft;
				XMax	=	kMandel_FarRight;
				YMin	=	kMandel_FarTop;
				YMax	=	kMandel_FarBottom;
				break;
			
			case 1:
				XMin	=	-1.7018;
				XMax	=	-1.7016;
				YMin	=	-0.000075;
				YMax	=	 0.000075;
				break;

			case 2:
				XMin	=	-0.197272275682447305;
				XMax	=	-0.196537412401197305;
				YMin	=	-0.67495234375;
				YMax	=	-0.67436640625;
				break;

		}
		maxcol	=	gWidth;
		maxrow	=	gHeight;
		deltaP	=	(XMax - XMin) / (maxcol);
		deltaQ	=	(YMax - YMin) / (maxrow);
		
		QQ[0]	=	YMin;
		for (row=1; row<=maxrow; row++)
		{
			QQ[row]	=	QQ[row-1] + deltaQ;
		}

		ii	=	0;
		while (columnSteps[ii] > 0)
		{
			deltaColumn	=	columnSteps[ii];
			for (col=startOffset[ii]; col < maxcol; col += deltaColumn)
			{
				PP	=	XMin + (deltaP * col);

				for (row=0; row < maxrow; row++)
				{
					X		=	Y	=	Xsquare	=	Ysquare	=	0.0;
					color	=	kStartColor;
					QQtemp	=	QQ[row];
					while ((color < kMaxItterations)  && ((Xsquare + Ysquare) < 4))
					{
						Xsquare =	X * X;
						Ysquare =	Y * Y;
						Y		*=	X;
						Y		+=	Y + QQtemp;
						X		=	Xsquare - Ysquare + PP;
						color++;
					}
					rgbColor.red	=	(255 - color) & 0xe0;
					rgbColor.green	=	((255 - color) << 3) & 0xe0;;
					rgbColor.blue	=	((255 - color) << 6) & 0xe0;;
					setPixel(col, row, &rgbColor);
				}
				if (gettouch())
				{
					keepGoing	=	false;
					break;
				}
			}
			ii++;
			if (gettouch())
			{
				keepGoing	=	false;
				break;
			}
		}
		if (keepGoing)
		{
			delay(2500);
		}
		itteration++;	
	}
}


#ifdef _SHOW_RGB_IMAGE_
static uint8_t gRGBimage[] PROGMEM = {
0,64,0,59,0 ,	//xSize_hi, xSize_lo ,ySize_hi, ySize_lo

//* Line # 0
19,33,33,  20,33,34,  21,36,36,  25,39,39,  27,40,40,  28,40,40,  31,43,42,  32,44,42,  35,46,44,  38,48,45,  40,49,46,  
41,50,46,  42,50,46,  44,52,47,  46,53,48,  49,56,51,  53,58,52,  59,63,57,  68,72,66,  72,74,68,  76,77,72,  82,82,77,  
68,66,62,  62,64,54,  73,69,58,  97,79,70,  111,82,75,  131,101,94,  133,114,104,  105,99,85,  99,92,82,  92,82,76,  88,77,71,  
83,74,68,  75,69,65,  70,71,69,  63,71,69,  57,66,63,  54,64,59,  52,61,57,  49,58,55,  47,57,55,  46,57,55,  48,59,58,  
48,60,59,  46,58,56,  46,57,55,  43,56,53,  45,58,53,  46,60,55,  46,60,54,  51,63,58,  61,69,66,  63,73,69,  63,74,69,  
63,73,67,  69,76,70,  78,82,77,  86,87,82,  95,91,88,  99,97,93,  102,100,96,  101,100,96,  98,98,94,  
//* Line # 1
22,35,36,  23,36,37,  23,37,38,  27,40,41,  29,42,42,  32,45,44,  32,44,43,  37,48,47,  38,49,47,  39,49,46,  41,51,48,  
43,52,48,  43,51,47,  44,52,48,  47,54,49,  48,55,50,  57,60,53,  63,64,57,  70,70,64,  71,71,64,  72,70,65,  80,78,73,  
74,71,66,  120,111,115,  170,161,165,  213,208,209,  206,203,203,  216,213,212,  235,227,228,  222,209,217,  213,193,188,  191,164,149,  169,143,129,  
126,101,89,  106,87,77,  90,80,72,  80,77,72,  69,69,66,  63,66,62,  52,60,55,  47,60,54,  43,59,53,  43,59,55,  48,60,58,  
51,62,59,  49,61,53,  49,61,53,  49,62,52,  51,63,54,  53,65,55,  54,67,56,  55,67,57,  63,72,63,  66,75,66,  64,75,64,  
65,76,64,  70,77,66,  76,80,70,  87,87,78,  100,94,86,  104,98,90,  106,101,92,  106,102,93,  105,101,92,  
//* Line # 2
22,36,36,  25,38,39,  27,41,42,  31,45,46,  33,46,46,  35,48,47,  36,47,46,  39,51,49,  39,51,49,  40,50,47,  43,53,50,  
44,54,51,  43,52,49,  47,56,51,  49,56,51,  49,57,52,  57,61,55,  62,65,59,  69,71,66,  72,72,68,  72,71,68,  80,77,75,  
156,153,151,  221,212,209,  194,178,173,  172,150,145,  178,152,149,  181,156,153,  179,160,158,  204,191,190,  216,196,187,  213,182,168,  178,144,129,  
160,123,108,  153,117,103,  140,111,97,  118,95,84,  93,75,68,  79,69,66,  64,66,59,  49,63,53,  42,61,52,  46,63,55,  51,63,58,  
53,63,57,  54,65,56,  54,64,55,  57,67,58,  60,70,59,  61,71,60,  65,74,63,  64,73,62,  69,76,66,  71,79,69,  68,77,66,  
68,76,65,  72,77,66,  78,81,70,  90,90,78,  100,96,85,  107,102,91,  110,106,95,  111,108,97,  110,109,97,  
//* Line # 3
23,36,37,  25,39,39,  30,44,45,  31,45,46,  34,48,48,  36,49,48,  37,49,48,  39,51,50,  43,54,52,  43,55,51,  44,56,52,  
46,57,53,  47,57,52,  47,57,52,  48,56,51,  49,57,51,  53,61,57,  58,65,62,  67,71,68,  72,72,70,  76,74,73,  147,142,140,  
196,188,188,  148,134,127,  154,136,125,  160,140,130,  171,150,142,  190,171,164,  230,214,210,  247,236,233,  248,237,234,  233,216,211,  203,176,166,  
180,142,127,  165,123,104,  162,120,100,  150,110,90,  145,111,97,  114,91,83,  87,76,65,  62,65,53,  56,68,55,  53,66,56,  59,67,61,  
59,67,63,  61,70,66,  63,72,67,  65,72,68,  69,75,71,  69,74,69,  71,76,71,  71,76,71,  73,78,73,  71,78,72,  70,77,71,  
72,78,71,  78,81,74,  85,85,78,  94,92,86,  102,102,93,  112,113,103,  114,116,106,  117,119,110,  117,121,111,  
//* Line # 4
22,35,36,  23,36,37,  26,40,41,  30,44,45,  33,46,47,  35,47,47,  37,49,48,  39,50,49,  41,52,51,  41,53,50,  45,57,53,  
46,58,53,  45,56,52,  46,56,51,  49,58,52,  50,59,53,  53,60,56,  60,66,63,  69,70,66,  75,71,66,  123,112,106,  225,210,203,  
188,169,162,  197,176,163,  229,214,198,  240,224,209,  247,232,219,  251,236,226,  250,237,228,  237,223,218,  227,218,216,  222,212,208,  218,194,184,  
201,163,145,  192,146,124,  191,143,120,  161,115,92,  150,109,89,  126,90,73,  132,105,88,  109,94,79,  77,71,59,  67,68,60,  67,72,66,  
67,73,70,  67,75,73,  69,76,73,  71,77,74,  74,78,75,  74,77,74,  77,79,75,  77,79,76,  76,80,76,  72,76,73,  71,76,71,  
75,79,74,  82,84,79,  92,91,86,  106,104,98,  117,117,109,  129,129,120,  132,133,124,  131,133,124,  129,132,122,  
//* Line # 5
25,38,39,  25,39,39,  24,38,39,  28,41,42,  32,45,45,  34,47,46,  36,48,47,  37,48,47,  39,50,48,  40,52,49,  41,54,50,  
43,55,51,  45,57,52,  47,57,52,  46,57,51,  50,61,54,  61,65,58,  78,77,69,  86,80,70,  125,111,100,  195,173,159,  217,188,172,  
215,180,163,  225,193,167,  198,165,136,  203,164,139,  210,169,147,  196,158,139,  204,175,158,  235,214,197,  226,216,203,  217,200,186,  207,177,158,  
214,171,147,  196,148,123,  187,141,117,  164,122,102,  157,115,92,  129,82,58,  117,75,55,  128,95,80,  140,118,108,  98,89,82,  74,74,70,  
72,78,74,  71,80,73,  72,79,73,  76,82,75,  79,82,76,  78,80,73,  80,80,73,  80,80,73,  78,81,74,  75,79,70,  72,77,68,  
77,81,72,  90,91,82,  105,103,95,  123,119,110,  135,130,118,  147,142,130,  150,145,134,  146,143,131,  140,138,125,  
//* Line # 6
28,42,41,  28,41,40,  24,38,37,  26,39,38,  28,41,40,  32,45,43,  35,47,46,  36,48,46,  38,49,47,  40,50,49,  41,52,50,  
44,55,51,  46,56,51,  46,56,50,  47,56,49,  50,59,53,  61,63,55,  85,76,66,  124,103,89,  158,127,109,  185,150,129,  181,144,123,  
146,106,87,  105,71,52,  102,73,52,  135,107,86,  164,136,116,  146,118,100,  177,147,134,  207,175,168,  206,182,168,  225,204,185,  199,170,151,  
198,158,133,  190,142,109,  184,137,104,  179,137,113,  183,141,116,  188,141,111,  140,92,67,  114,68,49,  132,95,82,  154,130,121,  115,104,98,  
90,88,81,  76,77,69,  80,81,73,  81,82,75,  83,83,76,  83,82,74,  82,81,73,  80,80,71,  78,82,73,  77,82,72,  76,80,70,  
84,86,76,  100,99,89,  117,115,105,  132,129,118,  142,137,125,  154,147,133,  158,150,137,  155,147,133,  150,143,129,  
//* Line # 7
34,48,46,  33,46,44,  29,42,40,  24,38,36,  26,39,38,  31,43,42,  33,44,43,  36,46,45,  38,48,48,  42,50,50,  44,54,53,  
46,56,53,  45,56,52,  47,57,51,  50,59,53,  54,61,57,  57,60,54,  109,98,90,  150,121,107,  167,129,110,  172,135,112,  160,124,102,  
113,75,59,  89,55,42,  111,81,69,  111,79,64,  93,62,49,  135,108,93,  193,174,161,  210,196,185,  205,183,171,  184,154,143,  174,139,131,  
164,120,104,  159,106,77,  174,118,86,  158,104,82,  138,92,72,  175,133,107,  190,144,120,  162,114,93,  131,87,69,  142,106,90,  167,138,125,  
137,119,108,  104,96,89,  98,91,84,  86,82,76,  87,84,78,  86,83,78,  83,81,74,  81,81,73,  79,83,76,  79,82,75,  83,83,76,  
92,90,82,  106,104,95,  123,119,111,  135,131,122,  144,141,130,  154,148,136,  161,152,139,  160,150,136,  157,148,136,  
//* Line # 8
40,53,51,  38,50,49,  32,44,44,  30,43,43,  31,43,43,  32,44,44,  33,43,44,  37,47,48,  41,50,51,  46,53,52,  50,59,57,  
48,58,55,  47,59,55,  51,61,58,  52,61,58,  54,60,58,  71,74,69,  129,118,112,  158,131,119,  167,132,115,  199,164,143,  161,126,106,  
185,146,130,  219,199,189,  236,225,216,  223,208,197,  210,193,182,  206,186,179,  235,217,212,  245,226,224,  198,176,171,  185,157,150,  165,131,125,  
172,129,118,  154,104,83,  132,79,56,  153,100,84,  151,104,92,  133,93,78,  125,84,67,  162,120,99,  166,122,100,  161,116,94,  156,109,88,  
141,106,89,  124,110,100,  94,83,73,  98,90,83,  95,90,84,  92,89,82,  90,87,79,  88,86,77,  87,86,79,  87,86,78,  91,89,81,  
100,96,88,  111,106,98,  124,118,109,  135,128,120,  147,142,131,  154,148,135,  160,152,138,  160,151,136,  159,151,137,  
//* Line # 9
42,54,52,  41,53,51,  37,49,50,  37,48,49,  36,47,48,  36,46,48,  36,46,48,  41,50,52,  46,54,56,  51,57,54,  55,63,59,  
51,61,58,  51,62,60,  52,63,60,  55,62,59,  55,58,55,  84,82,78,  201,189,183,  195,169,159,  180,145,132,  189,155,138,  161,127,110,  
141,103,88,  153,123,115,  187,165,160,  219,202,196,  251,237,230,  255,245,238,  252,243,236,  246,240,234,  243,235,223,  227,214,199,  216,193,180,  
204,174,156,  197,166,143,  168,133,110,  135,96,75,  138,93,78,  163,116,102,  145,101,82,  131,89,66,  168,125,100,  146,98,75,  151,96,75,  
155,110,91,  128,104,89,  115,96,83,  112,99,90,  99,92,85,  98,93,86,  98,94,85,  97,92,83,  98,94,86,  100,95,87,  102,97,88,  
107,100,92,  114,106,97,  124,115,106,  134,126,116,  143,136,125,  150,143,130,  157,149,134,  160,152,136,  160,152,137,  
//* Line # 10
45,57,54,  43,54,51,  38,50,50,  39,50,51,  38,48,49,  40,50,51,  42,51,52,  45,53,55,  50,58,59,  56,62,58,  59,66,62,  
53,64,61,  53,63,60,  56,63,59,  62,63,57,  75,70,62,  175,167,160,  242,224,217,  204,172,163,  186,151,138,  192,159,143,  169,137,121,  
107,70,57,  101,68,58,  127,97,88,  161,134,124,  145,122,114,  187,166,156,  221,204,194,  224,206,196,  225,207,193,  230,205,187,  223,186,167,  
214,175,155,  193,159,137,  175,139,117,  141,97,75,  148,96,76,  166,113,96,  144,96,75,  129,86,62,  128,86,62,  142,96,75,  149,99,83,  
134,88,70,  150,114,93,  146,118,102,  118,100,89,  107,96,89,  106,100,92,  104,98,88,  104,98,87,  108,101,92,  108,101,93,  110,103,94,  
114,106,96,  118,110,100,  124,116,105,  131,123,111,  139,129,118,  145,137,124,  151,144,128,  156,149,133,  155,147,132,  
//* Line # 11
49,59,56,  44,54,51,  41,52,50,  44,54,53,  41,51,50,  42,52,50,  46,55,54,  49,56,56,  54,61,60,  58,64,60,  58,66,62,  
58,67,64,  58,66,63,  60,63,56,  76,69,58,  146,132,118,  232,212,199,  195,166,154,  195,156,145,  167,128,116,  145,112,98,  147,117,103,  
111,78,67,  144,113,100,  170,142,128,  137,110,98,  97,68,58,  76,45,35,  110,75,65,  125,88,78,  107,69,58,  125,78,66,  131,72,57,  
117,60,44,  115,69,56,  132,87,74,  131,72,56,  81,26,8,  100,58,42,  155,111,92,  161,115,95,  118,72,51,  132,86,66,  142,95,77,  
141,94,73,  131,85,60,  139,104,85,  124,101,89,  114,102,93,  111,103,94,  113,105,95,  111,103,92,  112,104,94,  113,106,96,  116,108,98,  
119,111,100,  120,113,101,  123,117,104,  129,122,110,  138,126,115,  141,132,118,  146,139,122,  154,148,130,  156,149,133,  
//* Line # 12
51,61,57,  47,57,54,  47,58,53,  47,58,53,  45,55,51,  45,54,50,  48,56,52,  51,57,54,  56,63,59,  60,67,62,  60,68,64,  
58,68,64,  61,67,62,  72,69,60,  88,73,59,  156,134,115,  193,163,143,  141,103,85,  146,101,87,  151,108,95,  140,107,94,  147,119,107,  
108,78,69,  99,61,53,  101,62,54,  85,50,44,  68,37,31,  66,36,29,  75,45,35,  84,51,39,  69,36,27,  83,40,32,  123,68,54,  
110,61,48,  74,41,33,  63,33,25,  116,71,56,  98,61,48,  35,12,6,  104,69,58,  128,83,68,  114,62,42,  127,75,50,  137,89,61,  
154,103,74,  140,88,60,  135,96,75,  145,120,107,  131,118,109,  122,114,106,  116,108,97,  117,108,97,  116,110,100,  118,111,100,  119,113,101,  
123,117,104,  120,115,102,  122,117,103,  128,122,108,  136,122,111,  136,126,112,  139,133,115,  150,145,126,  156,148,131,  
//* Line # 13
49,60,55,  49,60,55,  49,60,56,  47,58,54,  45,54,51,  47,55,52,  49,57,54,  52,60,57,  56,64,61,  59,68,66,  64,67,61,  
61,64,61,  56,64,62,  90,86,75,  160,134,111,  196,160,137,  158,122,105,  100,69,55,  96,66,53,  108,74,62,  108,70,56,  107,68,54,  
95,59,47,  99,66,49,  99,66,48,  93,58,44,  84,47,35,  97,57,46,  103,59,46,  111,63,49,  91,52,40,  73,37,26,  92,50,37,  
103,66,54,  82,54,45,  47,24,15,  51,24,12,  97,63,56,  52,31,26,  80,51,40,  126,72,62,  99,60,36,  126,72,46,  144,77,51,  
144,93,58,  163,105,74,  150,99,73,  145,105,84,  168,139,125,  156,139,128,  132,122,113,  124,115,105,  126,111,98,  121,109,97,  123,115,103,  
124,118,106,  123,118,106,  123,117,104,  127,120,107,  133,123,112,  135,127,115,  137,131,116,  145,139,124,  151,145,129,  
//* Line # 14
49,60,55,  49,61,55,  47,58,56,  46,56,54,  43,53,51,  45,54,52,  48,56,55,  51,59,58,  54,61,60,  55,66,66,  64,63,56,  
62,63,57,  52,63,65,  77,73,61,  164,130,103,  190,146,123,  117,84,71,  54,34,25,  47,33,24,  58,33,23,  102,60,45,  125,76,58,  
125,82,64,  131,90,67,  129,85,61,  121,76,56,  109,64,45,  108,62,44,  120,74,54,  114,68,45,  106,62,44,  88,47,33,  77,37,24,  
85,46,35,  96,60,51,  74,43,35,  43,20,11,  64,29,25,  84,59,52,  80,54,44,  114,60,51,  97,68,44,  116,65,41,  147,72,53,  
126,75,45,  147,91,64,  164,109,82,  160,109,85,  168,124,104,  161,130,113,  169,148,135,  160,141,129,  157,133,118,  138,119,106,  127,115,104,  
123,115,106,  125,119,109,  126,119,108,  127,119,108,  130,124,112,  134,128,116,  136,130,117,  141,135,122,  146,140,126,  
//* Line # 15
47,58,53,  47,58,53,  46,57,55,  45,55,53,  44,54,52,  45,54,52,  47,56,54,  50,58,56,  52,59,58,  53,63,64,  60,61,54,  
58,62,55,  53,64,64,  73,66,55,  146,112,87,  169,128,106,  106,79,69,  43,28,21,  24,12,7,  62,39,29,  122,80,64,  142,92,71,  
137,91,70,  138,91,68,  139,91,67,  132,84,62,  124,77,56,  113,65,45,  129,83,61,  124,78,53,  111,67,47,  98,55,40,  78,36,22,  
83,44,33,  76,42,33,  80,52,44,  47,24,17,  38,13,9,  50,28,24,  60,36,29,  83,47,38,  88,53,37,  92,45,27,  149,90,72,  
137,85,64,  134,85,64,  126,75,54,  154,103,81,  164,114,92,  182,139,117,  179,143,121,  178,147,127,  194,168,154,  143,122,108,  126,112,101,  
124,116,105,  127,121,111,  128,121,111,  127,119,108,  129,122,112,  132,125,114,  135,128,116,  140,133,121,  145,138,125,  
//* Line # 16
47,58,54,  47,59,54,  47,58,55,  45,55,53,  46,56,54,  45,54,53,  48,56,54,  50,57,56,  52,59,58,  53,63,65,  60,63,56,  
57,64,56,  53,64,63,  83,73,63,  149,112,89,  123,86,65,  44,25,18,  17,8,6,  15,9,5,  65,45,36,  126,84,67,  149,97,74,  
148,99,73,  149,98,73,  147,95,70,  136,85,61,  137,86,64,  119,69,47,  137,89,65,  133,85,58,  121,74,51,  105,60,42,  87,42,27,  
80,40,28,  68,35,26,  66,40,34,  55,34,30,  34,22,18,  37,19,17,  42,20,16,  46,27,17,  83,44,36,  62,21,12,  114,74,58,  
140,86,71,  152,100,79,  158,104,83,  137,81,59,  164,110,88,  167,118,97,  185,141,121,  204,167,148,  185,155,141,  140,115,101,  126,110,98,  
124,114,103,  125,118,108,  125,118,108,  126,118,107,  128,120,110,  130,122,112,  136,128,117,  140,132,121,  144,137,125,  
//* Line # 17
47,58,55,  49,60,57,  47,58,56,  45,55,53,  44,54,52,  46,54,53,  47,55,54,  49,57,55,  51,59,57,  54,62,66,  58,63,56,  
56,67,57,  51,63,61,  91,76,67,  143,104,84,  90,57,39,  23,9,5,  9,6,6,  12,10,8,  58,40,32,  133,92,75,  153,100,76,  
149,99,71,  153,102,74,  153,100,74,  142,91,66,  146,94,71,  128,77,54,  146,95,70,  143,93,65,  127,77,52,  114,65,45,  101,54,38,  
76,35,23,  64,31,23,  65,41,36,  52,35,33,  20,14,11,  40,24,25,  46,27,25,  30,21,13,  82,44,41,  63,28,20,  53,26,15,  
126,74,62,  127,71,47,  144,87,64,  168,112,90,  190,138,119,  204,159,142,  216,184,170,  229,197,184,  167,132,117,  140,111,97,  122,102,90,  
123,111,100,  122,113,103,  122,115,105,  124,116,106,  129,119,111,  132,123,114,  135,126,116,  140,130,121,  141,132,121,  
//* Line # 18
47,58,56,  49,60,57,  49,60,57,  48,59,56,  48,57,55,  48,56,55,  47,55,54,  49,57,55,  51,59,57,  53,60,65,  56,63,55,  
52,68,56,  54,66,63,  92,74,67,  129,88,70,  73,43,27,  28,18,15,  14,14,15,  11,12,10,  44,28,20,  123,85,67,  154,103,78,  
152,103,75,  152,104,75,  153,104,77,  148,98,73,  147,96,73,  130,78,55,  144,91,67,  154,101,74,  138,85,60,  120,68,46,  108,60,41,  
81,39,27,  57,24,17,  33,11,8,  25,11,11,  13,8,7,  28,15,16,  36,18,18,  28,17,12,  65,33,32,  64,36,31,  55,34,26,  
70,29,20,  111,62,42,  97,46,28,  110,60,42,  131,83,68,  144,102,89,  146,113,102,  159,125,114,  124,84,69,  135,102,88,  145,122,110,  
123,109,98,  122,113,103,  122,114,104,  122,114,105,  126,116,109,  132,122,114,  134,124,116,  134,124,115,  136,127,116,  
//* Line # 19
48,58,56,  49,60,57,  49,60,58,  50,61,58,  50,60,58,  50,59,57,  50,59,57,  53,60,58,  55,62,60,  56,62,68,  57,65,57,  
49,69,55,  55,68,64,  102,81,75,  127,85,70,  80,53,37,  27,18,14,  7,9,8,  6,8,6,  26,12,5,  104,67,48,  149,101,75,  
153,107,79,  149,106,77,  144,101,73,  145,98,73,  145,95,72,  129,76,55,  151,96,74,  160,103,80,  138,82,56,  138,84,61,  119,70,51,  
96,55,42,  58,27,20,  40,19,18,  21,8,9,  15,8,9,  24,11,11,  40,24,24,  34,18,17,  46,21,19,  63,40,36,  51,33,25,  
54,28,23,  85,53,48,  99,63,53,  133,93,81,  119,75,62,  99,56,43,  118,78,64,  152,113,97,  155,111,95,  144,108,93,  136,112,100,  
122,106,96,  120,111,102,  121,113,104,  122,114,104,  123,113,106,  128,118,110,  132,121,114,  131,121,112,  132,121,112,  
//* Line # 20
50,59,57,  51,59,58,  51,62,58,  52,63,60,  51,62,58,  52,60,58,  53,61,60,  54,63,61,  56,66,64,  57,68,69,  59,67,59,  
58,70,62,  68,72,71,  125,97,85,  138,94,73,  52,32,24,  7,4,2,  18,15,13,  6,5,3,  16,8,1,  100,68,54,  153,103,82,  
156,110,81,  133,94,65,  126,87,60,  116,74,49,  107,63,38,  105,57,33,  144,93,68,  157,104,77,  138,82,54,  157,99,72,  139,85,62,  
114,67,49,  63,29,19,  39,20,17,  15,9,12,  10,7,8,  22,9,6,  38,19,13,  55,30,22,  39,16,11,  48,28,24,  48,31,26,  
53,33,29,  95,67,61,  117,83,74,  137,97,85,  120,76,62,  120,77,63,  140,98,86,  92,53,40,  178,140,125,  158,126,113,  130,105,93,  
123,106,93,  121,110,98,  120,112,104,  119,111,107,  121,111,104,  122,112,105,  126,116,108,  129,119,110,  130,119,111,  
//* Line # 21
53,60,58,  55,62,59,  53,64,60,  54,65,61,  54,64,60,  54,63,60,  56,65,62,  57,67,64,  57,67,65,  56,71,66,  62,71,65,  
66,68,67,  91,80,77,  156,121,102,  114,74,53,  22,10,9,  3,5,4,  28,21,19,  12,5,4,  11,8,0,  89,62,52,  161,108,93,  
154,107,78,  153,107,80,  164,115,94,  151,103,82,  130,81,61,  125,74,53,  135,80,56,  159,99,73,  166,107,78,  170,112,82,  160,102,74,  
138,85,62,  99,59,43,  44,22,15,  21,15,14,  6,5,8,  13,7,7,  33,16,10,  51,28,20,  52,32,28,  36,19,17,  34,18,13,  
44,22,16,  75,44,36,  124,88,77,  142,101,87,  139,96,81,  115,74,62,  84,47,39,  118,84,74,  169,135,120,  149,118,109,  173,150,141,  
140,126,112,  120,111,96,  119,113,106,  117,111,109,  119,112,104,  119,112,103,  120,111,103,  122,113,104,  125,115,107,  
//* Line # 22
54,61,58,  56,63,60,  54,65,61,  54,65,61,  55,65,61,  56,65,62,  59,68,65,  63,71,68,  63,70,67,  61,71,66,  60,72,72,  
69,67,65,  123,95,80,  148,110,89,  67,40,29,  19,10,10,  1,0,0,  26,18,17,  13,6,5,  5,3,0,  69,43,35,  155,103,89,  
161,114,86,  169,117,91,  164,108,89,  139,89,74,  124,77,65,  136,87,74,  163,106,88,  180,114,91,  175,115,86,  172,117,86,  164,109,79,  
156,102,77,  119,74,53,  86,52,38,  38,14,6,  17,8,9,  3,2,9,  17,7,9,  31,18,20,  33,21,24,  43,30,31,  48,30,24,  
51,28,21,  63,36,35,  101,71,65,  81,45,35,  68,33,22,  95,60,50,  156,121,111,  193,157,145,  149,108,93,  158,126,118,  225,208,203,  
189,180,171,  124,119,105,  124,118,107,  121,114,107,  117,110,101,  116,109,100,  117,108,100,  116,108,99,  118,109,101,  
//* Line # 23
52,59,57,  54,61,59,  54,63,61,  54,63,60,  55,64,61,  56,66,62,  60,67,64,  64,69,66,  65,69,66,  68,69,63,  64,72,75,  
95,84,79,  169,125,99,  117,74,52,  64,48,46,  16,10,12,  0,0,0,  20,14,14,  12,7,6,  1,0,0,  56,32,24,  153,102,88,  
160,112,86,  150,106,76,  105,64,43,  83,52,38,  63,36,25,  84,55,44,  122,84,63,  162,112,84,  171,118,87,  169,116,85,  164,110,80,  
156,102,74,  133,81,56,  117,70,50,  90,47,33,  47,18,12,  27,10,8,  29,9,7,  33,16,17,  16,7,11,  13,6,9,  32,18,14,  
50,31,25,  81,56,56,  144,115,110,  192,160,150,  202,177,163,  211,181,165,  200,162,145,  182,142,125,  130,87,71,  139,105,99,  195,175,174,  
213,205,198,  134,131,117,  134,130,115,  124,118,105,  113,107,97,  108,102,92,  110,103,94,  110,102,93,  110,101,93,  
//* Line # 24
52,59,57,  52,58,56,  53,60,59,  55,64,61,  55,65,61,  55,65,60,  60,67,62,  65,68,64,  71,69,66,  71,65,56,  85,80,78,  
155,131,119,  158,106,77,  108,66,45,  65,51,50,  11,5,6,  4,2,1,  14,8,9,  13,9,9,  0,0,0,  47,25,18,  149,98,86,  
165,116,91,  156,112,82,  116,76,50,  118,85,66,  99,71,57,  114,85,69,  125,88,66,  154,107,79,  167,116,86,  168,116,86,  161,109,79,  
153,100,72,  161,108,81,  166,112,88,  169,114,92,  156,106,84,  131,86,64,  103,59,41,  68,35,24,  27,10,9,  8,1,3,  6,2,1,  
13,1,1,  32,9,8,  75,49,43,  109,77,66,  138,101,85,  154,113,95,  163,121,100,  159,116,95,  122,80,65,  142,107,101,  215,191,189,  
183,169,160,  168,160,143,  134,128,109,  128,121,106,  123,118,107,  109,104,93,  105,99,89,  104,97,88,  106,98,91,  
//* Line # 25
52,59,57,  52,59,57,  54,59,59,  54,61,60,  55,64,60,  56,65,60,  61,67,61,  65,65,60,  83,78,74,  101,85,74,  139,114,101,  
164,125,106,  123,74,51,  117,77,60,  64,44,37,  24,14,12,  5,2,2,  7,3,3,  13,9,10,  0,1,0,  39,19,13,  143,92,81,  
167,118,95,  173,121,96,  172,116,94,  160,107,88,  163,112,95,  164,112,95,  171,115,96,  180,120,99,  171,115,90,  171,118,91,  166,115,88,  
154,103,76,  160,108,82,  175,121,95,  180,122,98,  186,127,101,  183,123,92,  161,100,69,  124,74,50,  76,45,34,  15,4,3,  3,2,3,  
7,4,4,  16,1,0,  25,7,3,  40,15,8,  73,43,31,  98,61,47,  126,85,67,  114,72,55,  122,85,73,  151,116,108,  201,169,161,  
156,131,115,  160,143,120,  152,143,122,  137,131,115,  124,120,106,  109,104,92,  101,95,85,  101,95,86,  103,95,88,  
//* Line # 26
51,58,56,  54,60,58,  57,61,61,  57,63,63,  55,65,61,  53,64,58,  61,67,60,  72,71,65,  93,87,84,  137,116,104,  188,144,119,  
153,100,73,  123,81,66,  108,73,61,  84,54,39,  41,25,19,  4,1,2,  5,1,3,  10,8,10,  5,10,5,  34,16,8,  133,82,72,  
166,115,94,  171,125,100,  176,127,102,  184,132,105,  190,135,106,  189,133,106,  188,134,109,  179,129,106,  173,120,97,  172,117,93,  170,120,95,  
158,110,85,  155,107,82,  171,119,94,  182,126,102,  187,132,109,  181,125,101,  172,109,80,  148,91,62,  100,59,40,  25,7,3,  5,2,2,  
3,5,6,  4,3,5,  14,8,10,  26,15,14,  37,18,15,  58,32,26,  74,40,32,  93,59,48,  90,59,49,  108,71,61,  142,102,87,  
150,113,89,  181,157,129,  160,148,126,  137,132,117,  123,121,106,  108,104,92,  100,95,84,  99,93,84,  98,91,85,  
//* Line # 27
50,58,54,  54,61,58,  57,63,64,  56,62,59,  57,66,61,  59,68,64,  72,76,74,  78,71,66,  106,89,78,  171,130,111,  157,108,82,  
113,72,49,  112,78,64,  112,72,59,  108,69,56,  50,31,26,  3,1,2,  7,3,5,  10,8,9,  11,10,8,  34,19,14,  95,56,45,  
161,113,90,  167,122,95,  177,131,102,  183,134,105,  189,141,110,  191,145,113,  189,143,114,  178,131,106,  171,119,94,  169,116,90,  177,125,100,  
172,122,98,  158,108,84,  162,111,87,  176,125,99,  185,133,110,  175,125,101,  168,112,81,  157,93,66,  109,63,44,  22,10,4,  2,1,0,  
7,5,8,  8,8,10,  11,7,9,  32,22,23,  60,46,45,  71,52,51,  60,39,37,  38,19,16,  35,21,14,  47,22,15,  85,47,35,  
154,110,91,  200,164,142,  199,180,163,  181,173,161,  134,126,111,  117,109,95,  121,113,100,  104,96,86,  96,90,82,  
//* Line # 28
49,56,53,  52,58,57,  53,61,64,  57,64,61,  61,67,61,  73,79,77,  76,74,76,  98,82,74,  148,118,97,  176,116,90,  118,75,54,  
103,81,65,  107,77,61,  129,83,67,  114,73,63,  58,37,34,  7,4,4,  5,4,3,  10,4,5,  17,10,13,  25,13,14,  57,32,23,  
142,99,77,  169,116,87,  179,122,95,  187,131,104,  191,140,114,  189,144,116,  188,141,114,  183,126,101,  168,111,83,  171,118,88,  185,130,104,  
188,133,109,  170,115,92,  161,108,84,  169,119,92,  180,126,100,  173,121,90,  165,111,75,  159,92,66,  112,66,51,  14,11,5,  0,3,2,  
8,1,4,  14,6,5,  22,10,8,  38,21,19,  37,18,16,  32,15,14,  28,15,14,  28,19,18,  32,25,21,  52,37,34,  78,47,41,  
120,76,63,  182,138,123,  216,185,171,  191,173,161,  138,123,107,  129,114,99,  131,117,103,  118,107,95,  94,85,76,  
//* Line # 29
46,52,53,  49,55,56,  54,62,65,  57,63,62,  75,79,75,  73,75,71,  80,73,69,  123,101,87,  158,120,96,  139,85,61,  112,73,55,  
101,78,65,  112,82,67,  136,90,74,  119,77,65,  62,35,30,  13,8,8,  11,7,8,  8,3,4,  15,10,13,  19,11,14,  21,3,2,  
105,67,51,  162,111,82,  175,116,86,  182,122,94,  183,127,99,  183,134,105,  185,137,108,  176,121,95,  170,112,85,  173,117,88,  180,124,97,  
181,125,101,  161,107,82,  161,108,82,  170,117,90,  175,120,93,  173,118,89,  166,109,76,  156,93,69,  108,67,53,  13,7,3,  1,1,1,  
14,4,7,  19,8,9,  29,14,13,  31,12,11,  34,12,10,  39,19,17,  49,32,32,  43,26,24,  56,34,28,  56,33,27,  90,60,50,  
102,63,45,  141,98,76,  176,139,120,  196,166,151,  160,140,124,  142,123,108,  137,120,106,  141,125,114,  105,91,82,  
//* Line # 30
47,52,54,  51,56,58,  55,62,63,  62,66,66,  73,72,71,  70,66,61,  97,83,71,  151,120,99,  161,112,84,  124,74,52,  109,73,58,  
100,76,65,  124,93,79,  132,88,70,  124,82,65,  69,36,28,  23,12,13,  15,9,10,  10,4,4,  8,3,7,  25,19,22,  19,7,8,  
58,30,20,  150,102,75,  172,112,81,  179,116,87,  182,122,92,  181,129,97,  180,129,100,  174,119,93,  171,112,85,  167,108,79,  171,113,87,  
171,115,90,  164,108,84,  161,106,81,  169,112,86,  169,113,86,  171,114,85,  167,106,78,  152,95,73,  94,62,50,  9,2,0,  11,5,6,  
24,12,15,  23,11,12,  34,16,17,  39,17,17,  46,21,20,  57,33,31,  53,31,31,  45,22,21,  48,18,16,  53,30,27,  54,32,23,  
89,60,42,  124,87,64,  161,119,100,  172,133,117,  200,173,155,  192,167,151,  151,128,115,  139,118,107,  116,97,87,  
//* Line # 31
56,58,59,  63,64,65,  64,68,64,  73,71,71,  79,72,73,  81,71,64,  140,120,100,  180,141,113,  161,103,73,  131,83,59,  119,83,68,  
110,80,70,  131,96,82,  134,92,69,  138,94,74,  77,37,27,  37,19,19,  22,10,11,  19,9,8,  8,3,5,  14,11,13,  43,30,30,  
38,16,14,  112,68,47,  168,111,82,  177,113,84,  181,117,87,  180,123,91,  178,124,94,  175,118,91,  177,116,90,  173,113,86,  166,109,84,  
162,107,83,  160,107,83,  157,101,78,  165,107,83,  166,111,84,  170,112,85,  167,105,81,  146,100,79,  64,43,35,  5,0,0,  24,14,15,  
24,13,14,  28,15,18,  31,13,14,  45,21,20,  42,15,13,  45,19,17,  53,29,27,  42,17,16,  47,21,23,  45,29,31,  28,16,13,  
57,38,26,  133,100,83,  180,137,119,  204,161,145,  227,196,175,  191,162,144,  161,135,119,  133,109,96,  127,102,90,  
//* Line # 32
69,66,64,  73,70,67,  78,77,68,  89,81,79,  99,86,87,  97,81,70,  174,148,122,  180,136,103,  161,97,67,  131,82,56,  128,87,70,  
130,91,80,  139,100,83,  137,95,69,  141,96,73,  89,44,32,  49,24,22,  31,13,11,  26,11,8,  17,10,10,  7,4,7,  32,23,24,  
63,42,39,  81,44,29,  150,99,75,  174,112,87,  180,115,86,  181,121,89,  177,121,89,  176,118,90,  173,113,88,  160,99,76,  157,101,78,  
160,108,86,  160,109,88,  142,89,67,  128,71,49,  158,105,79,  166,110,83,  166,103,81,  131,95,75,  22,14,10,  11,3,3,  29,16,16,  
20,11,10,  25,14,16,  27,10,11,  39,15,14,  48,21,18,  54,27,24,  56,31,27,  44,21,18,  41,22,24,  33,23,26,  26,16,17,  
61,40,33,  89,53,38,  147,100,82,  200,153,135,  206,171,148,  188,156,136,  159,132,115,  147,121,107,  169,142,128,  
//* Line # 33
82,76,69,  85,79,72,  95,89,74,  103,90,87,  106,87,89,  117,96,85,  172,143,112,  174,127,90,  167,99,69,  144,93,64,  138,92,72,  
132,87,75,  152,109,90,  148,106,77,  151,107,81,  104,56,43,  61,31,28,  44,21,17,  38,20,13,  26,17,15,  12,9,11,  13,4,6,  
40,18,17,  77,45,31,  118,73,54,  173,113,92,  181,115,88,  183,120,89,  178,121,89,  178,118,88,  146,85,61,  141,82,62,  175,122,101,  
186,138,118,  175,127,108,  140,88,70,  133,76,58,  160,110,85,  167,112,84,  166,104,82,  91,63,46,  2,0,0,  15,7,6,  29,16,15,  
19,13,10,  17,7,9,  26,11,11,  39,17,16,  48,22,18,  63,37,33,  49,24,19,  43,22,16,  41,26,20,  34,21,22,  38,21,21,  
89,57,50,  181,134,118,  201,146,124,  195,141,117,  195,159,133,  183,150,129,  186,158,141,  217,192,177,  209,181,165,  
//* Line # 34
96,86,77,  96,85,76,  105,93,80,  111,94,87,  109,88,83,  131,107,92,  171,138,111,  162,117,85,  173,114,86,  161,105,74,  162,109,83,  
151,101,79,  147,101,76,  152,107,79,  162,116,91,  112,63,47,  69,32,24,  54,27,21,  43,24,20,  32,22,20,  18,11,11,  13,3,4,  
22,7,8,  37,16,9,  74,41,28,  142,93,73,  173,114,85,  179,117,84,  179,119,87,  176,118,90,  151,91,67,  139,79,56,  141,85,64,  
143,89,70,  148,95,77,  150,95,76,  156,98,78,  167,114,88,  163,112,84,  147,99,81,  36,18,13,  0,0,1,  18,12,12,  28,14,13,  
23,13,9,  17,6,7,  24,8,8,  40,18,16,  55,31,27,  53,29,25,  47,24,20,  38,21,17,  24,15,12,  24,13,13,  38,19,20,  
90,57,53,  137,91,79,  109,55,37,  152,100,80,  201,167,145,  219,186,165,  241,210,188,  233,203,180,  211,181,160,  
//* Line # 35
107,93,84,  109,95,86,  114,97,89,  117,100,88,  116,96,81,  127,101,84,  167,133,113,  131,90,68,  170,126,102,  189,133,104,  193,137,106,  
198,147,116,  182,135,105,  174,126,101,  142,93,71,  118,67,48,  76,33,19,  57,27,21,  34,18,18,  28,18,19,  20,10,8,  16,6,4,  
16,9,10,  15,6,7,  35,17,11,  79,45,28,  153,103,74,  171,112,79,  174,114,83,  173,116,90,  176,118,91,  165,103,76,  161,100,76,  
170,109,89,  171,111,91,  164,105,83,  167,110,84,  174,116,89,  164,114,89,  98,71,58,  3,0,0,  0,0,1,  14,10,12,  33,19,16,  
31,14,11,  20,7,7,  34,16,15,  50,28,26,  50,27,25,  46,25,23,  39,22,20,  24,12,11,  18,15,14,  26,19,18,  32,18,18,  
41,19,18,  56,26,23,  59,23,18,  93,52,45,  146,103,91,  179,134,116,  177,130,107,  165,120,93,  156,115,92,  
//* Line # 36
109,95,86,  109,95,85,  110,95,84,  116,100,88,  117,100,85,  115,94,77,  153,126,107,  110,79,59,  116,79,59,  155,108,82,  182,136,108,  
212,168,141,  215,175,149,  198,153,129,  187,136,115,  124,69,50,  72,30,17,  53,24,19,  30,15,15,  23,14,15,  19,10,8,  19,9,7,  
19,11,11,  6,1,1,  25,11,8,  50,19,10,  101,53,36,  152,94,71,  169,109,82,  171,115,85,  174,116,86,  175,116,87,  171,112,86,  
167,108,85,  169,111,88,  177,119,95,  178,122,96,  173,115,87,  160,108,83,  73,43,31,  6,0,0,  0,0,2,  12,8,11,  30,17,15,  
28,12,10,  27,12,15,  37,19,20,  41,19,19,  37,15,14,  26,8,6,  20,6,6,  26,16,13,  23,19,10,  22,16,10,  24,16,11,  
32,20,16,  36,18,15,  64,41,37,  100,69,62,  148,94,80,  167,113,94,  163,108,86,  148,96,74,  144,98,80,  
//* Line # 37
109,95,84,  108,94,83,  110,95,81,  111,96,83,  115,101,85,  108,92,76,  128,108,91,  119,95,79,  105,77,61,  136,99,78,  123,86,63,  
150,115,92,  197,161,139,  205,164,143,  190,140,121,  129,71,52,  75,33,22,  46,19,15,  28,14,16,  19,11,12,  16,7,5,  20,10,8,  
21,12,12,  3,1,1,  18,9,8,  46,17,16,  77,30,23,  115,56,42,  150,90,66,  168,112,79,  173,116,83,  178,118,88,  180,121,92,  
182,124,96,  181,124,96,  184,128,100,  177,121,92,  169,110,81,  143,88,63,  72,40,29,  7,0,0,  1,1,3,  7,4,7,  24,13,11,  
23,8,7,  30,14,18,  30,12,14,  32,11,12,  30,9,9,  31,14,13,  30,18,17,  22,14,12,  10,7,2,  5,3,0,  9,4,1,  
36,26,22,  52,35,31,  46,23,18,  82,52,42,  146,103,80,  187,145,120,  187,145,119,  188,152,127,  185,156,136,  
//* Line # 38
115,101,89,  110,96,84,  111,96,81,  113,99,83,  114,100,84,  111,97,81,  102,85,69,  137,116,101,  121,98,84,  126,94,75,  131,100,81,  
107,80,62,  132,103,86,  181,146,129,  189,144,128,  139,84,67,  73,33,23,  40,15,12,  22,9,12,  15,7,10,  15,6,5,  24,14,12,  
20,11,11,  4,1,2,  22,11,12,  47,17,17,  83,34,28,  126,67,52,  143,83,57,  152,95,61,  166,108,74,  178,118,86,  182,123,91,  
184,125,93,  180,122,90,  175,118,87,  169,112,82,  159,99,69,  138,81,56,  77,42,31,  9,0,0,  1,1,3,  7,6,8,  19,11,10,  
22,8,8,  23,9,12,  37,18,20,  39,19,18,  41,20,19,  47,30,28,  27,13,11,  15,7,6,  9,7,12,  9,7,10,  11,5,6,  
41,28,24,  48,23,17,  82,46,36,  129,87,73,  166,126,103,  206,164,141,  205,164,141,  198,162,139,  207,178,159,  
//* Line # 39
117,104,90,  115,102,88,  128,111,96,  124,108,92,  119,104,88,  115,99,82,  111,92,76,  118,96,80,  135,109,95,  147,115,98,  161,132,116,  
171,148,133,  211,192,179,  204,177,164,  202,165,152,  146,99,84,  68,32,23,  37,14,12,  17,5,8,  14,7,10,  17,8,8,  30,19,16,  
16,7,6,  12,3,5,  32,14,14,  58,23,17,  103,51,36,  138,76,53,  158,95,65,  158,98,64,  155,94,60,  167,104,71,  174,112,77,  
175,114,78,  169,109,74,  161,101,68,  163,104,73,  161,97,68,  138,79,53,  82,45,33,  9,0,0,  0,0,3,  3,4,6,  12,5,5,  
27,16,14,  22,9,9,  32,14,13,  43,21,19,  55,31,29,  50,28,26,  40,21,19,  24,10,11,  14,6,14,  13,7,12,  16,8,10,  
29,14,12,  39,13,7,  65,26,18,  102,56,46,  135,82,68,  163,109,94,  165,110,95,  151,98,84,  132,83,70,  
//* Line # 40
123,110,95,  124,110,95,  139,121,106,  134,116,100,  127,109,93,  123,104,86,  122,99,82,  124,96,80,  127,96,80,  152,117,101,  168,138,123,  
186,165,154,  218,202,192,  233,215,206,  208,179,169,  139,101,88,  68,34,27,  41,18,18,  13,2,6,  8,2,5,  20,11,10,  27,16,13,  
10,2,2,  23,9,12,  43,18,16,  85,44,29,  127,71,44,  147,83,48,  164,99,63,  167,104,72,  165,102,69,  166,99,66,  171,107,70,  
174,110,72,  170,107,70,  167,104,69,  168,105,74,  162,96,66,  134,74,49,  89,53,37,  10,1,0,  0,0,3,  1,1,3,  6,2,2,  
18,9,6,  29,18,14,  35,18,14,  50,27,23,  62,36,32,  64,37,33,  51,26,24,  43,20,18,  30,12,9,  20,7,5,  18,10,8,  
21,12,10,  25,10,10,  36,12,12,  48,16,14,  83,38,28,  107,59,48,  118,68,56,  112,61,48,  155,105,90,  
//* Line # 41
137,124,106,  137,125,106,  145,126,111,  160,139,125,  178,157,144,  169,148,136,  186,165,152,  203,182,168,  221,201,186,  228,197,182,  208,176,161,  
212,184,170,  221,201,189,  239,223,213,  216,188,180,  123,86,80,  67,36,29,  35,14,16,  14,4,11,  12,9,9,  19,15,11,  11,3,3,  
18,9,8,  41,16,12,  73,35,25,  111,62,42,  136,78,46,  154,89,52,  164,100,62,  166,103,69,  170,106,73,  172,106,73,  173,108,73,  
175,111,74,  172,107,72,  172,108,73,  170,106,74,  157,92,60,  132,71,43,  109,66,49,  31,9,7,  4,0,2,  1,1,4,  2,1,4,  
6,1,3,  17,7,7,  33,17,15,  45,22,17,  55,27,22,  50,22,17,  46,23,22,  37,18,16,  40,21,14,  35,20,14,  30,21,16,  
27,21,18,  30,20,19,  38,22,25,  52,31,32,  73,46,36,  80,46,34,  96,53,38,  129,81,63,  165,118,98,  
//* Line # 42
151,138,116,  154,140,117,  162,142,123,  189,166,150,  226,200,190,  221,193,186,  218,192,185,  225,206,196,  215,199,188,  228,196,174,  204,165,138,  
187,146,116,  179,137,108,  199,158,133,  206,164,146,  127,84,72,  69,40,29,  44,22,28,  25,13,24,  18,16,10,  7,6,1,  17,5,9,  
39,21,18,  77,37,23,  108,56,38,  126,70,48,  142,83,54,  153,92,59,  160,98,63,  167,107,71,  171,109,75,  174,109,77,  174,110,77,  
177,113,80,  173,109,76,  174,110,76,  172,107,74,  153,89,55,  131,70,39,  124,72,54,  73,35,31,  32,12,16,  4,1,4,  1,1,5,  
0,1,5,  2,2,5,  13,8,7,  24,12,7,  40,17,12,  48,23,20,  32,17,17,  24,14,15,  29,14,12,  27,15,12,  26,14,12,  
28,17,14,  28,13,11,  33,14,14,  40,20,19,  48,26,20,  67,35,24,  125,79,62,  156,101,80,  149,95,77,  
//* Line # 43
166,148,124,  172,152,127,  179,159,131,  189,164,139,  200,172,153,  188,152,137,  147,103,91,  163,121,110,  136,90,77,  175,126,94,  221,172,134,  
217,167,128,  210,159,120,  205,157,120,  209,161,130,  127,80,53,  76,45,29,  45,21,24,  27,10,15,  18,7,2,  18,3,0,  41,14,19,  
72,39,33,  102,58,43,  115,63,45,  134,79,57,  147,90,63,  153,93,62,  159,97,65,  167,106,73,  172,110,77,  175,112,79,  176,113,79,  
177,114,80,  174,112,78,  174,110,77,  170,107,73,  147,84,52,  130,70,42,  128,76,58,  91,51,44,  46,19,19,  12,0,1,  6,0,0,  
2,0,0,  0,2,1,  0,3,0,  5,4,2,  17,7,6,  43,24,25,  32,14,16,  24,10,10,  32,16,15,  27,14,12,  21,9,8,  
18,7,5,  17,6,4,  25,11,10,  28,13,12,  43,22,16,  64,34,25,  124,83,69,  163,115,98,  140,92,75,  
//* Line # 44
182,156,130,  186,159,132,  177,147,117,  193,164,138,  216,183,161,  174,129,112,  170,119,105,  163,108,95,  153,98,83,  146,89,69,  144,86,64,  
145,87,65,  147,90,68,  131,78,57,  125,74,57,  76,26,13,  49,16,3,  36,8,7,  38,12,11,  48,23,12,  78,47,43,  85,42,49,  
105,57,48,  109,59,40,  111,60,41,  124,71,49,  136,80,56,  143,85,58,  153,94,65,  161,102,70,  171,110,78,  176,114,81,  177,115,82,  
177,115,82,  173,111,78,  172,110,78,  163,101,68,  145,83,52,  129,71,46,  122,69,50,  109,65,53,  63,26,20,  59,29,25,  44,18,15,  
26,9,7,  10,3,1,  2,3,0,  0,1,0,  5,0,1,  28,13,16,  36,19,19,  27,11,9,  52,35,34,  40,24,23,  31,18,15,  
28,16,13,  29,18,15,  35,25,22,  45,33,30,  58,39,34,  59,34,27,  82,49,38,  110,71,58,  115,75,61,  
//* Line # 45
198,167,139,  187,151,123,  182,136,113,  219,173,152,  182,135,118,  177,131,116,  181,137,122,  179,135,119,  177,133,116,  178,125,112,  171,116,103,  
162,106,93,  153,98,86,  144,92,81,  130,83,73,  111,65,57,  89,53,39,  83,50,42,  97,61,54,  120,83,68,  142,97,96,  111,56,66,  
144,87,77,  145,92,71,  136,85,66,  131,79,58,  128,75,53,  128,73,49,  134,77,51,  144,86,59,  158,98,68,  167,106,75,  174,114,83,  
172,112,81,  166,105,75,  166,105,75,  155,94,63,  142,82,54,  122,64,42,  113,60,40,  108,60,43,  75,32,20,  80,38,29,  97,55,49,  
83,41,35,  63,25,19,  40,13,8,  29,10,8,  22,4,5,  24,6,6,  37,21,17,  25,11,6,  44,25,23,  53,33,31,  34,16,13,  
33,17,13,  33,18,14,  30,17,14,  37,24,20,  40,22,19,  39,19,14,  43,19,13,  79,51,44,  109,77,67,  
//* Line # 46
207,172,144,  178,137,109,  191,134,114,  177,121,103,  173,123,106,  173,128,113,  172,131,115,  171,133,115,  173,135,116,  177,133,110,  175,127,104,  
173,124,102,  169,121,99,  165,119,97,  159,115,94,  150,109,87,  142,103,84,  138,99,86,  142,99,86,  147,101,84,  144,91,94,  115,55,70,  
156,98,88,  160,106,84,  153,102,82,  150,99,80,  147,96,76,  146,93,73,  152,97,74,  150,92,67,  150,90,64,  154,94,68,  159,99,73,  
158,98,71,  152,92,66,  155,96,69,  141,81,54,  130,71,48,  114,57,37,  105,51,30,  103,52,32,  92,43,28,  91,41,31,  89,38,33,  
108,51,47,  109,48,38,  101,52,41,  86,45,34,  64,25,17,  50,17,11,  41,19,12,  29,12,5,  33,10,6,  38,15,10,  44,19,15,  
47,21,17,  41,19,14,  45,24,19,  35,15,10,  32,16,14,  35,20,17,  28,13,11,  41,23,19,  62,37,30,  
//* Line # 47
196,158,130,  190,146,119,  168,110,86,  173,116,94,  172,120,99,  172,125,104,  173,127,107,  178,131,111,  180,133,112,  179,134,112,  177,131,109,  
175,127,108,  172,122,104,  170,120,103,  166,119,100,  160,114,94,  157,113,93,  158,113,97,  160,111,93,  157,107,88,  145,88,96,  116,58,78,  
157,104,95,  157,106,82,  157,105,85,  158,108,89,  156,106,89,  155,104,86,  158,105,84,  166,110,87,  159,100,77,  154,94,72,  148,89,66,  
148,88,65,  151,91,69,  154,94,72,  147,88,65,  145,85,66,  141,83,66,  139,84,63,  139,86,65,  140,87,70,  143,89,79,  111,55,53,  
137,78,72,  148,88,68,  139,83,61,  124,70,46,  114,60,39,  104,56,44,  69,36,28,  36,13,5,  48,24,15,  54,26,20,  70,40,34,  
56,24,20,  67,36,31,  67,38,32,  51,25,19,  25,12,11,  27,16,16,  20,12,11,  21,10,8,  39,20,15,  
//* Line # 48
180,141,112,  183,135,108,  162,105,78,  173,118,92,  173,121,96,  174,124,101,  176,126,105,  180,128,107,  181,129,108,  178,130,114,  176,128,114,  
175,125,114,  174,122,112,  174,122,112,  174,123,112,  171,120,110,  169,123,103,  168,119,107,  163,118,101,  166,111,94,  146,89,99,  123,62,86,  
157,110,98,  156,106,86,  156,104,84,  156,107,88,  160,110,92,  161,110,92,  157,105,85,  163,108,87,  164,107,86,  159,101,80,  151,93,73,  
154,97,76,  159,102,81,  158,101,80,  158,100,79,  156,99,80,  154,99,80,  155,101,79,  156,104,80,  158,106,84,  161,107,93,  130,74,68,  
118,61,57,  130,76,60,  128,75,45,  130,74,46,  138,81,59,  134,80,58,  107,61,46,  47,14,9,  53,29,26,  70,39,32,  87,48,39,  
90,47,36,  87,45,34,  90,52,42,  91,58,50,  53,28,21,  27,10,8,  23,11,11,  15,6,7,  38,22,20,  
//* Line # 49
179,138,109,  177,125,96,  159,103,78,  173,118,94,  175,121,98,  175,123,101,  176,126,105,  176,127,108,  176,129,110,  176,128,110,  173,125,107,  
173,125,108,  176,127,111,  174,126,112,  177,128,115,  176,127,114,  174,132,108,  175,126,121,  166,127,115,  177,120,104,  145,88,99,  133,66,92,  
161,118,99,  157,108,95,  157,108,89,  155,105,86,  157,107,88,  160,108,88,  160,108,88,  158,106,85,  160,106,86,  162,107,87,  158,103,83,  
160,105,84,  161,106,85,  158,104,83,  156,101,80,  157,104,84,  157,106,85,  156,106,81,  156,106,78,  156,105,79,  153,101,81,  135,82,67,  
106,50,50,  119,63,64,  121,69,41,  129,75,53,  138,83,68,  142,90,59,  135,81,54,  74,28,22,  42,19,19,  84,49,43,  101,55,41,  
111,58,40,  131,80,61,  95,50,35,  97,55,40,  104,60,43,  53,21,11,  31,13,11,  27,15,17,  27,12,11,  
//* Line # 50
190,148,119,  169,116,89,  158,101,76,  171,116,91,  175,121,98,  176,123,101,  177,126,105,  178,128,107,  177,127,107,  174,126,108,  173,125,108,  
172,124,107,  173,126,110,  175,128,114,  180,133,120,  182,135,123,  180,137,115,  179,131,124,  170,130,116,  178,123,110,  142,84,98,  144,80,100,  
164,120,102,  161,113,98,  161,112,93,  157,108,89,  154,104,85,  155,104,85,  159,108,88,  158,106,85,  155,102,81,  158,104,84,  161,107,87,  
158,105,84,  155,101,81,  153,99,78,  153,99,78,  156,103,83,  156,105,85,  156,105,83,  154,103,77,  152,100,76,  150,98,78,  142,90,75,  
111,56,54,  123,66,68,  130,76,57,  131,78,59,  137,83,65,  139,88,57,  140,88,60,  118,70,56,  58,23,15,  66,26,17,  98,53,41,  
108,59,46,  133,86,70,  126,81,65,  87,42,25,  104,59,43,  85,51,41,  42,20,17,  30,14,15,  34,14,13,  
//* Line # 51
182,139,112,  164,109,83,  162,105,80,  169,113,89,  174,119,94,  176,122,98,  175,122,100,  175,122,100,  175,123,102,  173,124,104,  171,121,103,  
172,124,106,  175,128,112,  174,128,114,  181,136,123,  182,138,126,  181,138,119,  178,132,123,  172,129,114,  176,122,114,  138,76,96,  158,97,108,  
171,125,109,  167,119,104,  163,115,97,  161,113,95,  159,109,91,  159,108,90,  159,108,88,  158,107,87,  156,105,84,  155,102,82,  158,105,85,  
156,103,83,  154,102,82,  153,101,81,  152,100,80,  154,102,83,  155,104,85,  154,103,82,  151,101,78,  152,102,79,  151,100,81,  147,96,80,  
123,69,63,  111,54,58,  139,85,77,  136,84,72,  135,84,64,  138,87,57,  141,90,61,  142,89,69,  120,72,53,  74,28,13,  65,20,9,  
91,48,36,  114,69,56,  126,79,62,  110,62,42,  85,38,22,  96,58,48,  47,21,18,  28,7,7,  44,19,18,  
//* Line # 52
163,119,93,  163,108,83,  168,111,86,  171,115,90,  177,121,96,  176,121,96,  175,121,97,  175,121,97,  174,120,96,  172,119,97,  167,114,94,  
171,120,101,  173,124,107,  173,127,111,  180,136,122,  184,141,128,  184,140,123,  178,135,124,  178,133,115,  177,124,122,  136,71,96,  165,109,109,  
170,123,109,  166,121,104,  166,118,102,  165,117,99,  166,117,99,  162,112,94,  160,110,91,  158,107,88,  157,106,86,  155,104,84,  155,104,84,  
158,106,86,  159,108,88,  160,109,89,  158,106,87,  156,105,86,  155,105,86,  154,103,84,  153,103,82,  152,102,82,  151,101,83,  150,99,82,  
142,88,77,  110,53,54,  136,81,85,  142,91,85,  139,91,68,  138,89,60,  143,91,64,  150,95,69,  151,95,69,  136,85,65,  100,54,40,  
76,32,20,  83,37,23,  113,63,44,  126,75,53,  95,46,31,  75,34,24,  65,35,30,  46,20,19,  49,21,19,  
//* Line # 53
172,128,103,  162,105,82,  171,114,89,  173,117,91,  177,120,95,  177,121,95,  178,121,96,  176,120,95,  174,117,92,  170,112,87,  164,107,83,  
170,115,93,  174,123,102,  175,128,109,  183,138,120,  184,141,125,  184,138,123,  176,135,123,  181,135,113,  172,122,125,  135,67,98,  174,121,112,  
175,127,114,  167,123,105,  166,119,103,  164,117,100,  165,117,100,  163,114,96,  162,112,93,  160,110,91,  159,109,89,  156,106,87,  154,104,85,  
154,104,85,  158,108,89,  160,111,91,  162,112,91,  160,111,92,  160,110,92,  158,108,90,  156,107,88,  155,105,87,  154,105,86,  154,103,85,  
155,103,85,  129,72,69,  119,64,77,  146,96,94,  142,97,72,  140,93,66,  143,91,67,  148,93,67,  154,98,71,  153,98,76,  150,98,80,  
145,94,78,  121,70,53,  102,50,29,  106,55,33,  108,60,45,  68,27,16,  53,21,14,  97,70,65,  53,25,20,  
//* Line # 54
158,113,89,  165,106,85,  171,113,88,  174,117,91,  175,118,92,  177,120,93,  176,118,91,  175,118,91,  172,114,87,  169,106,80,  162,101,75,  
169,111,86,  175,121,97,  176,126,105,  180,134,115,  182,138,119,  183,136,122,  176,137,124,  186,138,114,  165,117,121,  138,67,102,  182,131,115,  
177,126,115,  168,124,107,  165,119,102,  161,114,98,  162,115,97,  161,113,95,  161,112,94,  162,113,94,  162,114,94,  162,114,94,  162,113,94,  
160,111,92,  159,110,91,  160,111,91,  160,112,92,  161,112,92,  161,111,94,  160,111,94,  158,109,92,  157,108,91,  155,106,88,  154,105,86,  
156,105,82,  150,92,84,  110,54,74,  143,95,94,  144,102,73,  143,96,72,  144,91,72,  148,93,68,  152,98,74,  157,101,78,  160,103,80,  
161,102,80,  160,104,82,  147,94,72,  123,72,52,  93,47,32,  76,36,24,  49,17,9,  52,25,19,  57,29,23,  
//* Line # 55
157,111,87,  170,110,87,  171,113,85,  175,118,90,  176,119,91,  177,119,92,  175,117,89,  177,118,90,  174,115,86,  165,102,72,  160,97,70,  
168,106,83,  173,116,92,  178,125,102,  179,131,110,  182,136,118,  183,140,126,  180,141,123,  188,134,121,  156,95,122,  147,74,110,  185,134,112,  
172,127,112,  167,125,109,  166,119,104,  162,114,99,  163,112,98,  162,111,96,  162,113,95,  160,114,95,  163,115,95,  167,118,100,  167,120,102,  
165,118,100,  164,116,99,  162,114,95,  160,112,93,  160,111,92,  161,111,92,  162,112,95,  160,110,94,  159,109,93,  157,107,90,  154,104,87,  
154,105,82,  156,105,93,  113,56,78,  119,63,78,  151,102,89,  148,100,80,  147,96,76,  148,95,72,  151,98,76,  156,100,77,  162,101,77,  
164,102,77,  163,103,77,  161,106,82,  158,106,82,  143,92,71,  105,60,44,  64,27,15,  54,22,13,  63,32,23,  
//* Line # 56
158,112,87,  174,111,85,  170,111,79,  175,117,86,  177,118,90,  176,117,90,  177,117,90,  179,119,90,  176,116,86,  163,101,70,  149,85,60,  
168,104,84,  175,114,92,  180,125,99,  179,129,106,  182,135,119,  180,143,129,  186,144,121,  178,112,126,  135,50,115,  140,63,102,  181,127,110,  
169,132,112,  164,124,111,  165,119,104,  161,110,98,  160,106,95,  160,106,95,  159,110,94,  159,114,95,  162,114,95,  168,117,102,  169,121,106,  
167,121,108,  166,121,107,  163,117,101,  159,113,94,  162,113,94,  164,113,95,  161,110,93,  158,107,92,  157,106,92,  156,105,91,  156,104,89,  
151,105,87,  149,109,93,  122,62,79,  109,37,83,  144,79,110,  155,103,90,  148,102,74,  146,96,77,  149,95,72,  155,99,76,  162,103,78,  
165,106,79,  165,106,78,  166,109,80,  165,107,78,  164,103,74,  146,91,67,  111,64,45,  70,30,16,  65,29,18,  
//* Line # 57
166,121,93,  171,111,81,  169,110,77,  173,115,84,  175,116,88,  176,116,91,  178,119,92,  179,120,92,  178,119,90,  168,106,75,  138,75,49,  
166,103,80,  176,115,89,  180,125,94,  183,133,105,  184,136,115,  183,141,120,  193,141,134,  149,76,107,  133,45,109,  137,54,105,  171,107,122,  
178,129,129,  164,124,110,  161,121,100,  159,114,96,  157,109,92,  157,105,89,  155,104,87,  158,109,91,  163,113,95,  168,118,102,  172,124,109,  
174,128,113,  172,127,112,  170,125,108,  167,119,102,  164,116,99,  161,113,97,  159,112,96,  159,111,95,  157,108,92,  154,106,90,  154,105,89,  
150,107,89,  150,110,91,  131,69,80,  122,40,105,  124,46,108,  156,97,96,  152,105,79,  148,99,86,  148,94,69,  151,96,69,  157,100,71,  
166,106,78,  169,110,82,  169,112,84,  167,109,82,  166,105,77,  153,98,73,  124,76,57,  75,35,20,  57,22,12,  
//* Line # 58
184,143,111,  171,112,79,  173,113,80,  173,114,83,  174,115,87,  176,116,90,  176,117,91,  178,120,93,  180,122,94,  173,111,81,  144,81,54,  
161,99,73,  177,117,87,  181,125,90,  185,134,102,  182,134,110,  187,136,115,  182,118,131,  133,50,103,  142,50,115,  144,54,117,  137,59,110,  
182,120,146,  173,127,122,  163,124,107,  160,117,99,  155,110,90,  153,106,85,  153,102,82,  157,104,86,  162,109,92,  167,117,98,  172,124,108,  
176,130,115,  174,130,115,  174,129,113,  172,124,107,  168,122,107,  164,118,106,  161,114,101,  157,112,96,  157,112,95,  155,110,92,  155,108,92,  
151,110,91,  149,107,91,  133,65,88,  127,37,115,  126,39,120,  133,65,92,  159,107,98,  150,100,88,  148,95,68,  147,93,64,  152,95,65,  
163,104,74,  171,112,83,  171,113,88,  170,112,87,  172,111,83,  160,104,78,  134,83,62,  79,37,21,  63,28,18,  
};



//*******************************************************************************
void	DisplayRawRGB(uint8_t *rgbData, int xLoc, int yLoc)
{
int			imageWidth, imageHeight;
int			byte1, byte2;
long		dataIndex;
int			ii, jj;
RGBColor	myColor;
int			myXX, myYY;


	dataIndex	=	0;
	byte1		=	pgm_read_byte(rgbData + dataIndex++);
	byte2		=	pgm_read_byte(rgbData + dataIndex++);
	imageWidth	=	(byte1 << 8) + byte2;
	byte1		=	pgm_read_byte(rgbData + dataIndex++);
	byte2		=	pgm_read_byte(rgbData + dataIndex++);
	imageHeight	=	(byte1 << 8) + byte2;

	//*	if x,y are negitive, then center
	myXX	=	xLoc;
	myYY	=	yLoc;
	if (myXX < 0)
	{
		myXX	=	(gWidth - imageWidth) / 2;
	}
	if (myYY < 0)
	{
		myYY	=	(gHeight - imageHeight) / 2;
	}
	if (imageWidth < 100)
	{
		myXX	=	0;
		myYY	=	0;
	}
	for (jj=0; jj<imageHeight; jj++)
	{
		for (ii=0; ii<imageWidth; ii++)
		{
			myColor.green	=	pgm_read_byte(rgbData + dataIndex++);
			myColor.red		=	pgm_read_byte(rgbData + dataIndex++);
			myColor.blue	=	pgm_read_byte(rgbData + dataIndex++);
		
			if (imageWidth < 100)
			{
			short	doubleX, doubleY;
			
				doubleX	=	myXX + (2 * ii);
				doubleY	=	myYY + (2 * jj);
				setPixel(doubleX,		doubleY, &myColor);
				setPixel(doubleX + 1,	doubleY, &myColor);
			
				setPixel(doubleX,		doubleY + 1, &myColor);
				setPixel(doubleX + 1,	doubleY + 1, &myColor);

			}
			else
		
			{
				setPixel((myXX + ii), (myYY + jj), &myColor);
			}
		}
	}
}

//*******************************************************************************
void	DisplayRGBimage()
{
	DisplayRawRGB(gRGBimage, -1, -1);
}
#endif




